# Алерты

## Именование директорий и файлов с конфигами
На один продукт выбирается одна директория. Например на весь Коннект с фронтэндами, бекэндами и админкой - папка `directory`, на все формы - `forms`. Имя директории, которое вы выберете, должно совпадать с именем какого-то одного ABC сервиса. Имя этого сервиса нужно использовать для привязывания ВСЕХ алёртов внутри этой директории. Его же нужно использовать для сборной панели сервиса, например, `forms` как у [Конструктора форм](https://yasm.yandex-team.ru/template/panel/common_service_alerts_template/abc=forms/). По этой панели можно видеть общую картину по сервису, она полезна для вывода на телевизор в комнате и для дежурного.

В директории лежат файлы конфигов, именовать их можно произвольно.

Хороший **пример**: у вас в продукте (В АБЦ заведен как forms) 
* четыре разных приложения - 2 фронта, бек и админка. 
* у бека есть две базы

Тогда структура файлов может быть выбрана такой: 

* `./forms/forms-back.monitorado.yml` - тут будут алерты бека и обеих баз
* `./forms/forms-front.monitorado.yml` - тут будут алерты 2 фронтов и админки

## Работа с Мониторадо

Для генерации алертов используется утилита [Monitorado](https://github.yandex-team.ru/search-interfaces/frontend/tree/master/packages/monitorado). Для того, чтобы менять алерты нужно:

1. Установить пакет monitorado `npm i -g @yandex-int/monitorado --registry=https://npm.yandex-team.ru` . 
   `-g` означает "глобально", вам наверняка понадобится `sudo`.
   Получить токен [тут](https://oauth.yandex-team.ru/authorize?response_type=token&client_id=171fcece39a04fd0a6b8b74950336008) 
   и положить его в переменную окружения `MONITORADO_OAUTH_TOKEN` (например, в `~/.zshrc`).
1. Внести необходимые изменения в файлы конфигурации.
1. Проверить, что получится в результате командой `monitorado diff -v -c connect/directory.monitorado.yml`
1. Закоммитить изменения в аркадию, дождаться принятия ПРа. Это очень важно, не перегенерируйте алерты, пока ПР не принят - 
   ревьюверы знают все правила того, как правильно организовывать нотификации, пороги и другие правила. 
   Критически важно чтобы алёрты были оформлены по всем правилам. Правила перечислены ниже.
1. Запустить перегенерацию алертов для каждого измененного файла. 
   Чтобы она отработала без ошибок у вас должны быть все доступы до окружений, балансеров, баз данных и других приложений, 
   в которых вы устанавливаете алерты. Мониторадо ходит в АПИ этих сервисов. 
   Пример: `monitorado exec -c connect/directory.monitorado.yml`. Мониторадо изменит, удалит и создаст алерты.

## Как оформлять алёрты

Любые изменения в алертах нужно проводить через процедуру ревью конфигов. 
Все указанные требования к алёртам критически важны. 
Внимательно и аккуратно меняйте свои алёрты.

Руками менять алерты в интерфейсах нельзя. 
Если вам нужно поменять срочно, поменяйте руками, но будьте готовы к тому, что если вы не пошлете ПР в этот репозиторий, 
то ваши изменения будут когда-нибудь удалены.

### Привязка к сервису
У каждого алерта должен быть указан ABC сервис, который соответствует имени директории конфига. 
Сервис для всех ваших алертов выбирайте один, т.к. он в итоге прорастет на общий дашборд на котором дежурный сможет видеть общую картину. 
В итоге в головане ваш алерт будет иметь заполненное поле ABC:

![АБЦ сервис](https://jing.yandex-team.ru/files/chapson/directory_internal_prod_errors_count_summ_2019-03-21_17-28-23.png)

### Уведомления
Уведомления настраиваются по такому принципу:
  * CRIT получают общие дежурные в СМС и Телеграмм.
  * CRIT получают менеджеры и администраторы сервиса в Телеграмм. Для того чтобы вместе с дежурным тоже видеть, что происходит что-то критичное.
  * CRIT получают дежурные вашего сервиса в Телеграмм. Когда сойдется https://st.yandex-team.ru/TOOLBOX-67 здесь будет еще и WARN.

В итоге в Головане это выглядит вот так:

![Уведомления в Головане](https://jing.yandex-team.ru/files/chapson/2020-01-31_10-29-37.png)

### Флаподав

[Презентация](https://wiki.yandex-team.ru/content/duty/instrukcii/Pravila-raboty-s-aljortami/.files/dokladflapodavkopija.key). [Документация](https://wiki.yandex-team.ru/sm/juggler/FlapDetector/).
Служит для решения проблемы того, что проверки могут присылать разные сигналы в короткие промежутки времени. И заваливать дежурных там, где достаточно прислать только один алерт.
По опыту трудно сразу правильно подобрать хорошие значения флаподава. Поэтому это как раз один из тех случаев когда нужно поэкспериментировать в интерфейсе Голована, подбирая нужные значения, а потом отправить ПР с хорошими значениями в репозиторий.

![флаподав](https://jing.yandex-team.ru/files/chapson/directory_internal_prod_errors_count_summ_2019-03-05_10-45-36.png)

![флаподав](https://jing.yandex-team.ru/files/smosker/doklad_flapodav_kopiya.key_2019-03-05_10-10-48.png)

### Рецепты
**Каждый** алерт должен быть снабжен ссылкой на рецепт починки. Если у вас нет рецепта - не заводите этот алерт, он не пройдет код-ревью. Рецепты создаются подстраницами в [кластере рецептов на Вики](https://wiki.yandex-team.ru/content/duty/common-duty/novyjj-klaster-dezhurnogo/klaster/%D1%80%D0%B5%D1%86%D0%B5%D0%BF%D1%82%D1%8B/).
Пример: 
```
  urls:
    - title: "Как чинить?"
      url: https://wiki.yandex-team.ru/content/duty/alerts-classification/recepty/mdb-cpu/
```
Ссылку "Как чинить?" дежурный увидит когда из Телеграмма перейдет в интерфейс джаглера.

### Звонки
тикеты на эскалацию по сервисным группам: https://st.yandex-team.ru/JUGGLER-3610 + !!нужен такой же для мониторадо!!

По критически важным "дизастер" алертам (в каждом сервисе они свои) настраиваются звонки дежурным. Для **всех сервисов** считаем критически важными алертами следующие: 
* 5xx с фронта и бека выше процента от суммы запросов 
* уровень ERROR в логах 
* алерты с продуктовыми метриками, не технологическими: доля спамеров, доля не срабатывания функциональности, итд итп.

Алерты выше считаем безусловно критически важными, по ним звонят всегда. Подробно о том как работает эскалация звонков можно почитать [на Вики](https://wiki.yandex-team.ru/sm/juggler/notifications/phoneescalation/).
Эскалацию можно настроить руками, но не нужно, потому что мониторадо эти настройки может затереть. Ждем когда это появится в мониторадо.

Ручная настройка: 
Зайти в настройки алерта в головане на вкладку "Уведомления", нажать кнопку "Добавить эскалацию", в появившемся поле перечислить список логинов в порядке очередности звонка. Подробно о том как работает эскалация можно почитать [здесь](https://wiki.yandex-team.ru/sm/juggler/notifications/phoneescalation/).

![флаподав](https://jing.yandex-team.ru/files/oleglarionov/%D0%A1%D0%BD%D0%B8%D0%BC%D0%BE%D0%BA%20%D1%8D%D0%BA%D1%80%D0%B0%D0%BD%D0%B0%202019-12-06%20%D0%B2%2017.44.29.png)

На данный момент нельзя указать группу пользователей для эскалации как в других уведомлениях, но у ребят отвечающих за juggler есть тикет на поддержку календаря дежурств https://st.yandex-team.ru/JUGGLER-3610
