import requests


def create_auto_alerts(token, selector, namespace, description=None):
    """
    Настраивает автозаведение тикетов для указанного алерта
    """
    headers = {
        'Authorization': 'OAuth {}'.format(token),
        'Content-Type': 'application/json',
    }
    description = description or 'Tools auto alert'
    juggler_api = 'https://juggler-api.yandex-team.ru/api/notify_rules/add_or_update_notify_rule/?do=1'

    data = {
        "selector": selector,
        "template_name": "push",
        "template_kwargs": '{"push_url": "https://tickenator.yandex-team.ru/api/tickenator.services.TickenatorService/createTicketSPIAuto"}',
        "namespace": namespace,
        "description": description,
    }
    response = requests.post(
        url=juggler_api,
        json=data,
        headers=headers,
        verify=False,
    )
    response.raise_for_status()


def create_for_all_signals(token, abc, namespace=None):
    """
    Настраивает автозаведение тикетов в https://workplace.z.yandex-team.ru
    для всех алертов привязанных к указанному abc сервису
    """
    headers = {
        'Authorization': 'OAuth {}'.format(token),
        'Content-Type': 'application/json',
    }
    namespace = namespace or abc
    response = requests.get(
        url='https://yasm.yandex-team.ru/srvambry/alerts/list?abc={}'.format(abc),
        headers=headers,
    )
    for i in response.json()['response']['result']:
        check = i.get('juggler_check')
        if check:
            alert_name = '&'.join((
                '{}={}'.format(key, value)
                for key, value in check.items()
            ))
            if alert_name:
                create_auto_alerts(
                    token=token,
                    selector=alert_name,
                    namespace=namespace,
                )
