import requests


def change_namespace(token, abc, namespace):
    """
    Изменяет у всех алертов, привязанных к переданному
    abc сервису, namespace на нужный

    Без этого сейчас некорректно работает автозаведение тикетов по сигналам
    """
    headers = {'Authorization': 'OAuth {}'.format(token)}
    response = requests.get(
        url='https://yasm.yandex-team.ru/srvambry/alerts/list?abc={}'.format(abc),
        headers=headers,
    )
    for i in response.json()['response']['result']:
        name = i['name']
        check = i.get('juggler_check')
        if check:
            alert_data = requests.get(
                url='https://yasm.yandex-team.ru/srvambry/alerts/get?name={}&with_checks=True'.format(name),
                headers=headers,
            )
            response_data = alert_data.json()['response']
            response_data['juggler_check']['namespace'] = namespace
            update_response = requests.post(
                url='https://yasm.yandex-team.ru/srvambry/alerts/update?name={}'.format(name),
                headers=headers,
                json=response_data,
            )
            update_response.raise_for_status()
