# coding: utf-8

import os
import requests

B_PREFIX = 'qloud-external/qloud/balancer'
balancers = set([
    'paste',
    'wf-intranet',
    'wiki-b2b',
    'tools-cia',
    'wiki-intranet',
    'wiki-intranet-ext',
    'wiki-b2b-int',
    'delta-int-ext',
    'jing-ext',
    'jingdav',
    'connect-production-balancer',
    'connect-internal-prod',
    'dns-hosting-external-prod',
    'forms',
    'forms-public',
    'forms-private',
    'forms-external',
])


def get_balancer_paths():
    for b in balancers:
        yield '/{}/{}/USER/'.format(B_PREFIX, b)
        yield '/{}/{}/MAINTAINER/'.format(B_PREFIX, b)


# https://idm.yandex-team.ru/group/154316/roles#f-status=all,sort-by=-updated
DUTY_GROUP = '154316'


def make_request(path, system, group):
    headers = {'Authorization': 'OAuth {}'.format(os.environ.get('OAUTH'))}
    url = 'https://idm-api.yandex-team.ru/api/v1/rolerequests/'
    params = {
        'path': path,
        'system': system,
        'group': group,
    }
    response = requests.post(url, headers=headers, json=params)
    if response.status_code != 201:
        print('{}: {}'.format(path, response.content.decode('UTF-8')))


for path in get_balancer_paths():
    make_request(path, 'Qloud-ext', group=DUTY_GROUP)
