import requests
import collections
import time
import datetime
import os

MAX_ALLOWED_COUNT = 50


def get_notifications_count(token, abc):
    headers = {'Authorization': 'OAuth {}'.format(token)}
    response = requests.get(
        url='https://yasm.yandex-team.ru/srvambry/alerts/list?abc={}'.format(abc),
        headers=headers,
    )
    date_from = datetime.datetime.now() - datetime.timedelta(days=7)
    from_time = int(time.mktime(date_from.timetuple()))
    result = collections.defaultdict(int)

    for i in response.json()['response']['result']:
        check = i.get('juggler_check')

        if check:
            host = check['host']
            service = check['service']
            page = 0
            has_more = True
            while has_more:

                notifications_response = requests.post(
                    url='https://juggler-api.search.yandex.net/v2/history/get_check_history',
                    json={
                        "host": host,
                        "service": service,
                        "statuses": ["CRIT"],
                        "since": from_time,
                        "page_size": 400,
                        "page": page,
                    },
                    verify=False,
                    headers=headers,
                )
                json_response = notifications_response.json()
                has_more = json_response['has_more']
                counter = len(json_response['states'])
                result['{}-{}'.format(host, service)] += counter
                page += 1

    count_sum = 0
    for elem in sorted(result.items(), key=lambda x: x[1], reverse=True):
        if elem[1] > 0:
            count_sum += elem[1]
            print(elem)
    if count_sum > MAX_ALLOWED_COUNT:
        print(
            'За неделю у вас {} срабатываний алертов, нужно '
            'не больше {} для обслуживания алертов общим дежурным'.format(count_sum, MAX_ALLOWED_COUNT)
        )


if __name__ == '__main__':
    token = os.environ.get('OAUTH')
    abc = os.environ.get('SERVICE')
    get_notifications_count(token, abc)
