import requests
from copy import copy


def set_notification_rules(token, abc, overwrite=True):
    """
    Настраивает стандартные уведомления при срабатывании алерта

    При overwrite=True перезаписывает все текущие алерты, кроме звонков
    """
    BASE_NOTIFICATIONS = [
        {"template_name": "on_status_change", "description": None,
         "template_kwargs": {"status": ["CRIT", "WARN"],
                             "login": ["@svc_{}_dutywork".format(abc)],
                             "method": ["telegram"]}},

        {"template_name": "on_status_change", "description": None,
         "template_kwargs": {"status": ["CRIT"],
                             "login": ["@svc_{}_dutywork".format(abc)],
                             "method": ["sms"]}},

        {"template_name": "on_status_change", "description": None,
         "template_kwargs": {"status": ["CRIT"],
                             "login": ["@svc_{}_projects_management".format(abc),
                                       "@svc_{}_administration".format(abc)],
                             "method": ["telegram"]}}
    ]

    headers = {'Authorization': 'OAuth {}'.format(token)}
    response = requests.get(
        url='https://yasm.yandex-team.ru/srvambry/alerts/list?abc={}'.format(abc),
        headers=headers,
    )

    for i in response.json()['response']['result']:
        name = i['name']
        check = i.get('juggler_check')
        if check:
            alert_data = requests.get(
                url='https://yasm.yandex-team.ru/srvambry/alerts/get?name={}&with_checks=True'.format(name),
                headers=headers,
            )
            response_data = alert_data.json()['response']
            if overwrite:
                notifications_copy = copy(BASE_NOTIFICATIONS)
                for j in response_data['juggler_check']['notifications']:
                    if j['template_name'] == 'phone_escalation':
                        notifications_copy.append(j)
                response_data['juggler_check']['notifications'] = notifications_copy
            else:
                response_data['juggler_check']['notifications'].extend(BASE_NOTIFICATIONS)

            update_response = requests.post(
                url='https://yasm.yandex-team.ru/srvambry/alerts/update?name={}'.format(name),
                headers=headers,
                json=response_data,
            )
            update_response.raise_for_status()
