import json
import traceback
from functools import partial

from typing import Callable, Dict, Tuple


_send_handler = None
_result_handler = None


def set_handlers(
    send: Callable[[Dict], None],
    result: Callable[[], Tuple[int, Dict]],
):
    global _send_handler
    global _result_handler
    _send_handler = send
    _result_handler = result


def dump_ctx_keys(context: Dict):
    """ Is for tests """
    context['debug_info']['ctx_keys_dump'] = [*context, *context['params']]


def create_context(context_params: Dict) -> Dict:
    ctx = {
        'debug_info': {},  # for debug purpose
        'params': context_params,
    }
    ctx['dump_ctx_keys'] = partial(dump_ctx_keys, ctx)
    return ctx


def on_complete(context: Dict) -> Dict:
    _send_handler({
        'status': 'flow_completed',
        'result': {},
        'debug_info': context['debug_info'],
    })


def on_exception(context: Dict, exc: Exception):
    _send_handler({'status': 'error', 'traceback': traceback.format_exc()})


def call_master(fu_name, **params) -> Dict:
    data = json.dumps(params)
    data['fu_name'] = fu_name
    _send_handler(data)
    return _result_handler()[1]
