from logging import getLogger

from django.core.exceptions import ValidationError
from startrek_client.exceptions import NotFound, StartrekError

from ok.tracker.base import ISSUE_KEY_RE, client as tracker


logger = getLogger(__name__)


def validate_issue_key(key):
    is_valid_key = bool(ISSUE_KEY_RE.match(key))
    if not is_valid_key:
        logger.warning('Issue key is invalid: %s', key)
        raise ValidationError(
            message='issue_does_not_exist',
            code='issue_does_not_exist',
        )
    try:
        tracker.issues.get(key=key, fields=['id'])
    except NotFound:
        logger.warning('Issue not found: %s', key)
        raise ValidationError(
            message='issue_does_not_exist',
            code='issue_does_not_exist',
        )
    except StartrekError as exc:
        logger.warning('Could not get issue %s: %s', key, exc)
        raise ValidationError(
            message='startrek_error',
            code='startrek_error',
        )
