from rest_framework.response import Response

from ok.api.core.views import BaseView
from ok.tracker.tasks import update_stage_from_comment
from . import forms


class CommentAddedTriggerView(BaseView):
    """
    Ручка получения вебхука о добавлении комментария
    """
    authentication_classes = []
    permission_classes = []

    def post(self, request, *args, **kwargs):
        check_form = forms.CommentAddedTriggerForm(data=request.data)
        self.validate(check_form)

        update_stage_from_comment.delay(issue_key=check_form.cleaned_data['issue_key'])
        return Response({'status': 'ok'})
