import yenv
from rest_framework.authentication import SessionAuthentication


class OkAuthentication(SessionAuthentication):
    """
    DRF-аутентификация OK-а. Основана на сессионной аутентификации,
    отличается от неё тем, что при походах в OK через oauth или tvm (в будущем),
    CSRF-защита отключается. В CSRF-защите нет необходимости, когда запрос
    отправляется не из браузера.
    FIXME: У нас сейчас есть уязвимость - мы никогда не проверяем
     CSRF для пользователей, которых нет в БД. Это будет лечиться в OK-163.
    """
    def enforce_csrf(self, request):
        # Не проверяем CSRF в dev-окружениях
        if yenv.type == 'development':
            return

        mechanism = request.yauser.authenticated_by.mechanism_name

        # Не проверяем CSRF при авторизации по oauth и tvm
        if mechanism in {'oauth', 'tvm'}:
            return

        return super(OkAuthentication, self).enforce_csrf(request)
