from django.core.management import BaseCommand
from django.db.models import Q

from ok.approvements.choices import APPROVEMENT_STATUSES, APPROVEMENT_TYPES
from ok.approvements.models import Approvement
from ok.approvements.tasks import set_approvement_tracker_comment_id_task


class Command(BaseCommand):

    help = 'Set tracker comment id for approvements'

    def add_arguments(self, parser):
        parser.add_argument('--only-active', action='store_true')
        parser.add_argument('--dry-run', action='store_true')

    def handle(self, *args, **options):
        approvement_ids = (
            Approvement.objects
            .filter(type=APPROVEMENT_TYPES.tracker)
            .filter(
                Q(tracker_comment_id__isnull=True)
                | Q(tracker_comment_id='')
                | Q(tracker_comment_short_id__isnull=True)
            )
            .values_list('id', flat=True)
        )
        if options['only_active']:
            approvement_ids = approvement_ids.exclude(status=APPROVEMENT_STATUSES.closed)
        print(f'Setting tracker_comment_id for {len(approvement_ids)} approvements')
        if options['dry_run']:
            return
        for approvement_id in approvement_ids:
            set_approvement_tracker_comment_id_task.delay(approvement_id)
