# Generated by Django 2.2.5 on 2019-10-07 13:19

from django.db import migrations


def set_stages_status(apps, schema_editor):
    ApprovementStage = apps.get_model('approvements', 'ApprovementStage')
    qs = ApprovementStage.objects
    
    qs.filter(is_approved=True).update(status='approved')
    qs.filter(approvement__status='closed', is_approved__isnull=True).update(status='cancelled')
    qs.filter(approvement__status='suspended', is_approved__isnull=True).update(status='suspended')
    qs.filter(approvement__status='in_progress', is_approved__isnull=True).update(status='pending')


class Migration(migrations.Migration):

    dependencies = [
        ('approvements', '0012_approvementstage_status'),
    ]

    operations = [
        migrations.RunPython(set_stages_status, lambda *args: None)
    ]
