# Generated by Django 2.2.5 on 2019-10-18 16:14

from django.db import migrations, models
import uuid


def generate_uuid(apps, schema_editor):
    Approvement = apps.get_model('approvements', 'Approvement')

    approvements = []
    qs = (
        Approvement.objects
        .filter(uuid__isnull=True)
        .order_by('id')
        .iterator()
    )
    for approvement in qs:
        approvement.uuid = uuid.uuid4()
        approvements.append(approvement)

    Approvement.objects.bulk_update(approvements, ['uuid'], 100)


class Migration(migrations.Migration):

    dependencies = [
        ('approvements', '0015_approvement_uuid'),
    ]

    operations = [
        migrations.RunPython(generate_uuid, lambda *args: None),
        migrations.AlterField(
            model_name='approvement',
            name='uuid',
            field=models.UUIDField(default=uuid.uuid4, editable=False, unique=True),
        ),
    ]
