from django.db import migrations, models
from django.db.models import Count


def update_approvals(apps, schema_editor):
    ApprovementStage = apps.get_model('approvements', 'ApprovementStage')

    ApprovementStage.objects.filter(need_all=False).update(need_approvals=1)

    for ap_stage in ApprovementStage.objects.filter(need_all=True).annotate(need_count=Count('stages')):
        ap_stage.need_approvals = ap_stage.need_count
        ap_stage.save()


class Migration(migrations.Migration):

    dependencies = [
        ('approvements', '0020_approvement_type'),
    ]

    operations = [
        migrations.AddField(
            model_name='approvementstage',
            name='need_approvals',
            field=models.IntegerField(
                default=None,
                help_text='Необходимое кол-во ОК, что бы окнулась группа',
                null=True,
            ),
        ),
        migrations.RunPython(update_approvals, lambda *args: None),
    ]
