import csv

from django.http import HttpResponse
from django.contrib import admin
from django.utils.html import format_html


def format_url(url, name=None):
    name = name or url
    return format_html(f'<a target="_blank" href="{url}">{name}</a>')


def export_as_csv(modeladmin, request, queryset):
    meta = queryset.model._meta
    field_names = [field.name for field in meta.fields]

    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = f'attachment; filename={meta.app_label}_{meta.model_name}.csv'
    writer = csv.writer(response)

    writer.writerow(field_names)
    for row in queryset.values_list(*field_names):
        writer.writerow(row)

    return response


export_as_csv.short_description = 'Export as CSV'


admin.site.add_action(export_as_csv)
