from logging import getLogger

import blackbox

from django.conf import settings
from django_yauth.authentication_mechanisms.tvm import Mechanism as BaseMechanism


logger = getLogger(__name__)


class Mechanism(BaseMechanism):
    """
    Переопределённый механизм, который устанавливает не только uid пользователя,
    но и логин, и любые другие пользовательские поля, в соответствии с настройками yauth
    """
    def get_person_user(self, *args, **kwargs):
        yauser = super().get_person_user(*args, **kwargs)
        try:
            info = self.get_userinfo(yauser)
            yauser.fields = info['fields']
            return yauser
        except Exception:
            logger.exception('Could not fetch user from Blackbox')
            return self.anonymous()

    def get_userinfo(self, yauser):
        bb = blackbox.Blackbox(
            blackbox_client=self.blackbox,
            tvm2_client_id=settings.YAUTH_TVM2_CLIENT_ID,
            tvm2_secret=settings.YAUTH_TVM2_SECRET,
        )
        authinfo = bb.userinfo(
            yauser.uid,
            '127.0.0.1',
            dbfields=list(settings.YAUTH_PASSPORT_FIELDS),
            **settings.YAUTH_BLACKBOX_PARAMS,
        )
        return authinfo
