from rest_framework.permissions import BasePermission


def is_yauser_authenticated(yauser):
    if yauser and yauser.is_authenticated():
        if yauser.authenticated_by and yauser.authenticated_by.mechanism_name == 'tvm':
            return yauser.is_impersonated
        else:
            return True
    return False


class IsYaAuthenticated(BasePermission):
    """
    Проверяем, что пользователь аутентифицировн. По-яндексовому.

    Аналогично IsAuthenticated из rest_framework.
    """

    def has_permission(self, request, view):
        return is_yauser_authenticated(request.yauser)
