#!/usr/bin/env python
# coding: utf-8
import os
import sys

from django.core.management import execute_from_command_line


if 'YENV_TYPE' not in os.environ:
    app_env = os.getenv('QLOUD_ENVIRONMENT') or os.getenv('DEPLOY_STAGE_ID') or ''
    if app_env.startswith('tools_ok_'):
        app_env = app_env[len('tools_ok_'):]
    os.environ['YENV_TYPE'] = app_env

os.environ['YENV_NAME'] = 'intranet'
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'ok.settings')


def django_main():
    execute_from_command_line(sys.argv)


def celery_main():
    import django
    from celery.__main__ import main

    django.setup()
    return main()
