from django.urls import path

from . import approvements, views


urlpatterns = [
    path(
        'approvements/<int:pk>/example/',
        views.ApprovementEmailView.as_view(
            notification_class=approvements.ApprovementExampleNotification,
        ),
    ),
    path(
        'approvements/<int:pk>/approved_by_responsible/',
        views.ApprovementEmailView.as_view(
            notification_class=approvements.ApprovementApprovedByResponsibleNotification,
        ),
    ),
    path(
        'approvements/<int:pk>/cancelled/',
        views.ApprovementEmailView.as_view(
            notification_class=approvements.ApprovementCancelledNotification,
        ),
    ),
    path(
        'approvements/<int:pk>/finished/',
        views.ApprovementEmailView.as_view(
            notification_class=approvements.ApprovementFinishedNotification,
        ),
    ),
    path(
        'approvements/<int:pk>/question/',
        views.ApprovementQuestionEmailView.as_view(),
    ),
    path(
        'approvements/<int:pk>/required/',
        views.ApprovementEmailView.as_view(
            notification_class=approvements.ApprovementRequiredNotification,
        ),
    ),
    path(
        'approvements/<int:pk>/suspended/',
        views.ApprovementEmailView.as_view(
            notification_class=approvements.ApprovementSuspendedNotification,
        ),
    ),
    path(
        'approvements/overdue/',
        views.ApprovementOverdueEmailView.as_view(),
    ),
    path(
        'approvements/reminder/',
        views.ApprovementReminderEmailView.as_view(),
    ),
]
