from django.conf import settings
from django.utils import timezone


def get_message_id(prefix, instance_id, timestamp=None):
    timestamp = timestamp or timezone.now()
    return '<{prefix}#{instance_id}-{timestamp}@{host}>'.format(
        prefix=prefix,
        instance_id=instance_id,
        timestamp=timestamp.strftime('%Y%m%d%H%M%S'),
        host=settings.OK_HOST,
    )
