from django.contrib import admin

from ok.staff.models import Group, GroupMembership


@admin.register(Group)
class GroupAdmin(admin.ModelAdmin):

    list_display = (
        'url',
        'is_deleted',
    )

    list_editable = (
        'is_deleted',
    )


@admin.register(GroupMembership)
class GroupMembershipAdmin(admin.ModelAdmin):

    raw_id_fields = (
        'group',
    )

    search_fields = (
        'login',
        'group__url',
    )

    list_display = (
        'id',
        'login',
        'group',
    )

    list_select_related = (
        'group',
    )
