from django.db import models


class Group(models.Model):

    url = models.CharField(max_length=255, primary_key=True)
    is_deleted = models.BooleanField(default=False)

    def __str__(self):
        return f'Group {self.url}'


class GroupMembership(models.Model):

    login = models.CharField(max_length=64, db_index=True)
    group = models.ForeignKey(
        to=Group,
        on_delete=models.CASCADE,
        related_name='memberships',
    )

    def __str__(self):
        return f'GroupMembership {self.id}: @{self.login}, {self.group_id}'

    class Meta:
        unique_together = ('login', 'group')
