from ok.staff.models import Group, GroupMembership
from ok.utils.lists import chunks
from ok.utils.staff import get_staff_group_memberships


def sync_group_memberships(group_urls=None, chunk_size=100):
    if group_urls is None:
        group_urls = list(Group.objects.values_list('url', flat=True))
    for group_urls_chunk in chunks(group_urls, chunk_size):
        memberships = GroupMembership.objects.filter(group__in=group_urls_chunk)
        memberships_map = {(m.group_id, m.login): m.id for m in memberships}
        to_create = []
        for membership_data in get_staff_group_memberships(group_urls_chunk):
            key = group_url, login = membership_data['group_url'], membership_data['login']
            if key in memberships_map:
                memberships_map.pop(key)
            else:
                to_create.append(GroupMembership(group_id=group_url, login=login))

        GroupMembership.objects.bulk_create(to_create, batch_size=1000)
        GroupMembership.objects.filter(id__in=memberships_map.values()).delete()
