# Generated by Django 2.1.7 on 2019-04-17 13:52
import re

from django.db import migrations

ISSUE_KEY_RE = re.compile(r'^(?P<queue>[a-zA-Z]{1,15})-\d+$')


def fill_tracker_queue(apps, schema_editor):
    Approvement = apps.get_model('approvements', 'Approvement')
    Queue = apps.get_model('tracker', 'Queue')

    for approvement in Approvement.objects.filter(tracker_queue__isnull=True):
        data = ISSUE_KEY_RE.match(approvement.object_id)
        if not data:
            continue

        queue_name = data.group('queue').upper()
        queue, _ = Queue.objects.get_or_create(name=queue_name)
        approvement.tracker_queue = queue
        approvement.save()


class Migration(migrations.Migration):

    dependencies = [
        ('tracker', '0002_queue'),
        ('approvements', '0009_approvement_tracker_queue'),
    ]

    operations = [
        migrations.RunPython(fill_tracker_queue, lambda *a, **kw: None),
    ]
