from functools import wraps
from hashlib import sha1

from django.core.cache import cache


def memoize(seconds=900):

    def inner(f):
        @wraps(f)
        def x(*args, **kwargs):
            bytes_key = (f.__module__ + f.__name__ + str(args) + str(kwargs)).encode('utf-8')
            key = sha1(bytes_key).hexdigest()
            result = cache.get(key)
            if result is None:
                result = f(*args, **kwargs)
                cache.set(key, result, seconds)
            return result
        return x

    return inner
