from ids.registry import registry

from ok.utils.staff import get_staff_users_by_logins


OFFICE_GEOBASE_ID = {
    'innopolis': 11119,
    'kzn': 11119,
    'simf': 977,
}


def get_calendar_repository():
    return registry.get_repository(
        service='calendar',
        resource_type='holidays',
        user_agent='ok',
    )


def get_country_holidays(country_id, date_from, date_to, out_mode='holidays'):
    repo = get_calendar_repository()
    params = {
        'country_id': country_id,
        'start_date': date_from,
        'end_date': date_to,
        'out_mode': out_mode,
        'who_am_i': 'ok',
    }
    return repo.getiter(params)


def get_holidays(login_list, date_from, date_to):
    params = {
        '_fields': 'login,location.office',
    }
    result = {}
    holidays = {}

    for user in get_staff_users_by_logins(login_list, params):
        country_id = get_geobase_id_by_office(user['location']['office'])
        if country_id not in holidays:
            holidays[country_id] = list(get_country_holidays(country_id, date_from, date_to))
        if holidays[country_id]:
            result[user['login']] = holidays[country_id]

    return result


def get_geobase_id_by_office(office):
    """
    Возвращает geobase_id страны по офису. Отдельно учитывает Крым и Татарстан.
    """
    return OFFICE_GEOBASE_ID.get(
        office['code'].lower(),
        office['city']['country']['geobase']['id'],
    )

