from threading import local


class _RequestContext(object):
    """
    Псевдо-синглтон для сохранения какого-либа контекста в рамках http-запроса.
    """
    context_fields = ['user', 'referer', 'ok_session_id', 'flow_name']

    def __init__(self):
        self._data = local()
        self.reset()

    def set(self, key, value):
        setattr(self._data, key, value)

    def init(self, **kwargs):
        for key, value in kwargs.items():
            self.set(key, value)

    def reset(self):
        reset_data = dict.fromkeys(self.context_fields)
        self.init(**reset_data)

    def __getattr__(self, item):
        return getattr(self._data, item, None)


request_context = _RequestContext()
