import pytz


TZ_MOSCOW = pytz.timezone('Europe/Moscow')


def get_beginning_of_moscow_day(dt):
    """
    :param dt: aware datetime
    :return: Start of moscow datetime
    """
    assert dt.tzinfo is not None
    current_dt = dt.astimezone(TZ_MOSCOW)
    return current_dt.replace(hour=0, minute=0, second=0, microsecond=0)
