from ids.registry import registry
from django.conf import settings

from ok.utils.lists import chunks


def get_gap_repository():
    return registry.get_repository(
        service='gap2',
        resource_type='gaps',
        user_agent='ok',
        oauth_token=settings.OK_ROBOT_TOKEN,
    )


def get_gaps(login_list, date_from, date_to, **kwargs):
    repo = get_gap_repository()
    params = dict(
        date_from=date_from.isoformat(),
        date_to=date_to.isoformat(),
        **kwargs,
    )
    for login_chunk in chunks(login_list):
        params['person_login'] = login_chunk
        yield from repo.getiter(params)
