from django.conf import settings
from django.utils.functional import cached_property

from yt import wrapper as yt


hahn_client = yt.YtClient(
    proxy='hahn.yt.yandex.net',
    token=settings.YT_TOKEN,
)


class YTTable:

    schema = {}
    path = None

    def __init__(self, client=None):
        self.client = client or hahn_client

    def serialize(self, row):
        return row

    def create(self, **kwargs):
        attributes = {}
        if self._schema:
            attributes['schema'] = self._schema
        self.client.create(
            type='table',
            path=self.path,
            recursive=True,
            attributes=attributes,
            **kwargs,
        )

    def alter_schema(self):
        self.client.alter_table(
            path=self.path,
            schema=self._schema,
        )

    def write(self, rows):
        rows = [self.serialize(row) for row in rows]
        try:
            self._write(rows)
        except yt.YtHttpResponseError as e:
            if e.is_resolve_error():
                self.create()
                self._write(rows)
            else:
                raise

    @cached_property
    def _schema(self):
        return [{'name': k, 'type': v} for k, v in self.schema.items()]

    @cached_property
    def _yt_table(self):
        return self.client.TablePath(self.path, append=True)

    def _write(self, rows):
        self.client.write_table(
            table=self._yt_table,
            input_stream=rows,
            force_create=not self._schema,
        )
