"""
WSGI config for ok project.

It exposes the WSGI callable as a module-level variable named ``application``.

For more information on this file, see
https://docs.djangoproject.com/en/2.1/howto/deployment/wsgi/
"""
import os

from django.core.wsgi import get_wsgi_application


if 'YENV_TYPE' not in os.environ:
    app_env = os.getenv('QLOUD_ENVIRONMENT') or os.getenv('DEPLOY_STAGE_ID') or ''
    if app_env.startswith('tools_ok_'):
        app_env = app_env[len('tools_ok_'):]
    os.environ['YENV_TYPE'] = app_env

os.environ['YENV_NAME'] = 'intranet'
os.environ.setdefault("DJANGO_SETTINGS_MODULE", "ok.settings")

application = get_wsgi_application()
