# coding: utf-8
from __future__ import unicode_literals


class BaseStorage(object):

    def cut(self, date):
        """Deletes old messages in the log"""
        raise NotImplementedError

    def append(self, data, action):
        """Adds a new message to the log, and then returns it"""
        raise NotImplementedError

    def insert(self, msg_id, data, action):
        """Adds an existing message with the message id in the log"""
        raise NotImplementedError

    def get_one(self, msg_id):
        """Returns the message as dict object by message id"""
        raise NotImplementedError

    def get_last_id(self):
        """Returns last message id in the log"""
        raise NotImplementedError

    def get_next_id(self, current_id):
        """Returns next message id in the log after current_id"""
        raise NotImplementedError

    def get_slice(self, start, stop=None, max_rows=None):
        """Returns slice as the log iterator"""
        raise NotImplementedError

    def delete_one(self, msg_id):
        """Removes the message from the log by message id"""
        raise NotImplementedError

    def serialize_objects(self, objs):
        """Serialize a data object to add the message"""
        raise NotImplementedError
