# coding: utf-8
from __future__ import unicode_literals

import datetime
import re
import sys

from emission.core.exceptions import EmissionImproperlyConfigured


def now_str():
    return str(datetime.datetime.now())


def import_object(name):

    if callable(name):
        return name

    match = re.match(r'(.*)\.(\w+)$', name)

    if match:
        module_name, object_name = match.groups()
    else:
        msg = "'%s' doesn't match python dotted path pattern"
        raise EmissionImproperlyConfigured(msg % name)

    try:
        __import__(module_name)
        module = sys.modules[module_name]
    except ImportError:
        msg = "Module '%s' can not be imported"
        raise EmissionImproperlyConfigured(msg % module_name)

    try:
        obj = getattr(module, object_name)
    except AttributeError:
        msg = "Object '%s' not found in module '%s'"
        raise EmissionImproperlyConfigured(msg % (object_name, module_name))

    return obj
