# coding: utf-8
from __future__ import unicode_literals, absolute_import

from django.db import models

from emission.core.utils import now_str


class BaseLog(models.Model):
    ACTION_CHOICES = [
        ('modify', 'modify'),
        ('delete', 'delete'),
    ]

    class Meta:
        verbose_name = 'Incremental log for model changes'
        verbose_name_plural = verbose_name
        abstract = True

    data = models.TextField()
    creation_time = models.CharField(max_length=32, default=now_str, db_index=True)

    action = models.CharField(max_length=10, choices=ACTION_CHOICES, default='modify')

    def __unicode__(self):
        return '%d "%s"' % (self.id, self.data)
