# coding: utf-8
from __future__ import unicode_literals

from django import forms

from . import settings


MODELS = [name.lower() for name in settings.REPLICATED_MODELS]


class SliceForm(forms.Form):
    start = forms.IntegerField()
    stop = forms.IntegerField(required=False)
    multipart = forms.BooleanField(required=False)


class EntityForm(forms.Form):
    name = forms.ChoiceField(choices=zip(MODELS, MODELS))
    multipart = forms.BooleanField(required=False)


class MetaForm(forms.Form):
    current = forms.IntegerField(required=False)
