# coding: utf-8


def export():
    import os
    from libra.books.models import BookCover

    with open('covers.txt', 'w') as out:
        for cover in BookCover.objects.all():
            filename = os.path.basename(cover.img_large.path)
            cover.img_large.close()
            out.write('%s\t%s\n' % (cover.id, filename))


# /var/lib/yandex-tools-libra/media/covers/large/
def load(path_to_files):
    import os
    from libra.books.models import BookCover

    with open(os.path.join(path_to_files, 'covers.txt')) as input:
        for line in input:
            if line:
                id_, imname = line.split()
                try:
                    cover = BookCover.objects.get(id=int(id_))
                    cover.download(os.path.join(path_to_files, imname), int(id_))
                except Exception:
                    print "cant load %s %s" % (id_, imname)
