/*
*  Модуль, обслуживающий режим "корзина"
* */
kiosk.init_handlers.basket = function(k){
// Обработчик инициализации экрана "Корзина"

    kiosk.total_pages = function() {
        // возвращает количество "страниц" в корзине
        return Math.ceil(kiosk.basket_stack.length/kiosk.BASKET_ITEMS_PER_PAGE);
    }

    $(".b-button.basket-cancel").click(start_screen);

    $(".b-basket-paginator .b-prev").mousedown(function() {
        // клик "назад" по страницам корзины
        kiosk.basket_page -= (kiosk.basket_page > 0) ? 1: 0;
        redraw_basket();
    });

    $(".b-basket-paginator .b-next").mousedown(function() {
        // клик "вперед" по страницам корзины
        kiosk.basket_page += (kiosk.basket_page < kiosk.total_pages()-1) ? 1: 0;
        redraw_basket();
    });

    $(".b-basket-books .b-basket-prompt").removeClass('g-hidden');

};

// Обработчик инициализации экрана "Корзина"
kiosk.rfid_handlers.basket = function(rfid_data){
    switch(rfid_data.type) {
        case 'book':
            add_book(rfid_data);
            break;
        case 'user':
            reassign_books(rfid_data.login, rfid_data.rfid_number);
            break;
        default:
            alert('Поднесена неизвестная книга или пропуск.');
            break;
    }
};

// Забирает html с сервера и показывает экран "Корзина".
function basket_screen(basket_mode) {
    kiosk.basket = {}; // очистим "корзину"
    kiosk.basket_mode = basket_mode; // режим корзины: "взять" или "вернуть" книги
    kiosk.basket_stack = [];    // стек ID книг
    kiosk.basket_page = 0;      // переставим паджинатор на первую страницу
    kiosk.BASKET_ITEMS_PER_PAGE = 4; // максимальное количество книг на одном экране

    $.getJSON(kiosk.url_basket,{mode: basket_mode}, function(data, status){
        $('.b-content-frame').html(data.html);
        init_screen('basket');
    });
}

// Переназначает текущего держателя книг (либо возвращает их в библиотеку)
function reassign_books(user_login, rfid_number) {
    if(kiosk.basket_stack.length > 0) {
        var params = {
            mode: kiosk.basket_mode,
            books: kiosk.basket_stack,
            login: user_login,
            rfid_number: rfid_number
        };
        $.post(kiosk.url_basket_action, params, function(data){
            // очистим список книг
            kiosk.basket_stack = [];
            redraw_basket();
            $(".b-basket-books .b-basket-prompt").addClass('g-hidden');

            // покажем Спасибку в конце
            // тут дибильный кусок кода для изменения формы слова в зависимости от количества книг
            var text_1 = String(data.success_count);
            var last_digit = Number(text_1.substr(-1,1));
            var text_2 = " книг", text_mode = '';
            if(last_digit == 1) text_2 += "у";
            if(last_digit >= 2 && last_digit <= 4)  text_2 += "и";

            if(kiosk.basket_mode == 'take') text_mode = 'взяли ';
            if(kiosk.basket_mode == 'restore') text_mode = 'вернули ';

            var text = "Вы " + text_mode + text_1 + text_2 + ". Спасибо за то, что читаете книги и пользуетесь нашей библиотекой!";
            $('.b-basket-books .b-final-msg').html(text);
            $('.b-basket-books .b-final-msg').removeClass('g-hidden');
            $('.b-button.basket-cancel').html('На главную');
            window.setTimeout("start_screen", 3000);  // вернемся на стартовую автоматически
        },'json');
    } else {
        // поднесли пропуск при пустой корзине. Что тут показывать?
    }
}

// Добавление книги в корзину
function add_book(data) {
    // проверим наличие этой книги в корзине
    var bid = data.bookitem_id;
    if(kiosk.basket[bid] == undefined) {
        kiosk.basket[bid] = data;
        kiosk.basket_stack.push(bid);
        kiosk.basket_page = kiosk.total_pages() - 1; // двигаем текущую страницу вслед за новой книгой
        redraw_basket();
    } else {
        alert('Эта книжка уже есть в списке');
    }
}

// Удаление книги из корзины
function remove_book(bid) {
    var i = $.inArray(bid, kiosk.basket_stack);
    if(i >= 0) {
        kiosk.basket_stack.splice(i,1);
        kiosk.basket[bid] = undefined;
        kiosk.basket_page = kiosk.total_pages() - 1; // двигаем текущую страницу вслед за новой книгой
        redraw_basket();
    }
}

function redraw_basket() {
// отрисовывает текущую страницу корзины
    if(kiosk.basket_stack.length > 0) {
        $(".b-basket-books .b-basket-prompt").addClass('g-hidden');
    } else {
        $(".b-basket-books .b-basket-prompt").removeClass('g-hidden');
    }
    var start_index = kiosk.basket_page * kiosk.BASKET_ITEMS_PER_PAGE, end_index = start_index + 3
    var view_books = kiosk.basket_stack.slice(start_index, end_index + 1);  //+1 потому что конец интервала не включает элемент
    $(".b-basket-books .b-basket-bookitem").remove();

    // выведем книги текущей "страницы"
    for(i=0; i<view_books.length; i++) {
        var bid = view_books[i];
        $(".b-basket-books").append(kiosk.basket[bid].html);
    }
    paginator_visibility();     // покажем или скроем паджинатор
    finalizer_visibility();     // покажем/спрячем приглашение поднести пропуск

}

function paginator_visibility() {
// Изменяет видимость паджинатора в зависимости от количества книг в корзине
    var b_paginator = $(".b-basket-paginator");
    // если книг больше, чем вмещается на страницу, то покажем паджинатор
    if(kiosk.basket_stack.length > kiosk.BASKET_ITEMS_PER_PAGE) {
        var label = (kiosk.basket_page+1).toString() + ' из ' + kiosk.total_pages().toString();
        $(".b-num", b_paginator).html(label);
        b_paginator.removeClass("g-hidden");

        if(kiosk.basket_page < 1) $(".b-prev", b_paginator).addClass("disabled");
        else $(".b-prev", b_paginator).removeClass("disabled");

        if(kiosk.basket_page == (kiosk.total_pages()-1)) $(".b-next", b_paginator).addClass("disabled");
        else $(".b-next", b_paginator).removeClass("disabled");

    } else {
        // иначе уберем паджинатор
        b_paginator.addClass("g-hidden");
    }
}

function finalizer_visibility() {
// Если в корзине есть книги, то покажет плашку "поднесите пропуск", иначе спрячет её
    if(kiosk.basket_stack.length > 0) {
        $('.l-basket .basket-rfid').removeClass("g-hidden");
    } else {
        $('.l-basket .basket-rfid').addClass("g-hidden");
    }
}