(function($){
    $(function(){
        $('.b-add-book').each(function(){
            var params = this.onclick ? this.onclick() : {};

            // выбор владельца
            var ownerselect = $('.js-owner-select select',this),
                owner = $('.js-owner',this),
                rfid_block = $('.rfid-block', this);

            ownerselect.change(function(){
                if (this.value == 'PR') {
                    owner.removeClass('g-hidden');
                    owner_input = $('#id_owner');
                    if(owner_input.val()) {

                    }
                    else {
                        owner_input.val(params.current_user_login);
                    }
                    rfid_block.addClass('g-hidden')
                } else {
                    owner.addClass('g-hidden');
                    rfid_block.removeClass('g-hidden');
                }
            })

            // где находится книга
            var locinputs = $('.js-loc-select input[type=radio]'),
                locwhere = $('.js-loc-where',this),
                locwho = $('.js-loc-who',this);
            var on_location_change = function() {
                if (this.value == 'lib') {
                    locwhere.removeClass('g-hidden');
                    locwho.addClass('g-hidden');
                } else {
                    locwhere.addClass('g-hidden');
                    locwho.removeClass('g-hidden');
                }
            };
            var checked = null;
            locinputs.each(function() {
                if (this.checked) {
                    checked = this;
                    return false;
                }
            });
            locinputs.change(on_location_change);
            on_location_change.call(checked);

            var book_url = $('#book_url'),
                fill_fields = $('#fill_fields'),
                update_state_interval = null,
                filling_interval = null;

            var good_url = function(url) {
                if (url.indexOf('www.') == 0) {
                    url = 'http://' + url;
                    book_url.val(url);
                }
                if (url.indexOf('https://www.amazon.com') == 0
                    || url.indexOf('https://www.ozon.ru') == 0
                    || url.indexOf('https://www.books.ru') == 0) {
                    url = 'http' + url.substring(5);
                    book_url.val(url);
                }

                if (url.indexOf('http://www.amazon.com') == 0) return true;
                if (url.indexOf('http://www.ozon.ru') == 0) return true;
                if (url.indexOf('http://www.books.ru') == 0) return true;
                return false;
            };
            var update_button_state = function() {
                var url = book_url.val();
                if (url && good_url(url)) {
                    fill_fields.removeAttr('disabled');
                } else {
                    fill_fields.attr('disabled', 'disabled');
                }
            };
            book_url.focus(function() {
                if (update_state_interval == null) {
                    update_state_interval = window.setInterval(update_button_state, 50);
                }
            });
            book_url.blur(function() {
                if (update_state_interval != null) {
                    window.clearInterval(update_state_interval);
                    update_state_interval = null;
                }
            });
            update_button_state();
            var filling_progress = function() {
                var text = fill_fields.html();
                if (/\.\.\.$/.test(text)) {
                    fill_fields.html('Заполнение');
                } else {
                    fill_fields.html(text + '.');
                }
            };
            var autofill_start = function() {
                fill_fields.html('Заполнение');
                if (filling_interval == null) {
                    filling_interval = window.setInterval(filling_progress, 250);
                }
                $('#id_title').attr('disabled', 'disabled');
                $('#id_isbn').attr('disabled', 'disabled');
                $('#id_authors_string').attr('disabled', 'disabled');
                $('#id_year').attr('disabled', 'disabled');
                $('#id_publisher_name').attr('disabled', 'disabled');
                $('#id_publisher_id').attr('disabled', 'disabled');
            };
            var autofill_end = function() {
                fill_fields.html('Заполнить поля');
                if (filling_interval != null) {
                    window.clearInterval(filling_interval);
                    filling_interval = null;
                }
                $('#id_title').removeAttr('disabled');
                $('#id_isbn').removeAttr('disabled');
                $('#id_authors_string').removeAttr('disabled');
                $('#id_year').removeAttr('disabled');
                $('#id_publisher_name').removeAttr('disabled');
                $('#id_publisher_id').removeAttr('disabled');
            };
            fill_fields.click(function() {
                var url = book_url.val();
                autofill_start();
                $.ajax({
                    url: '/books/autofill/',
                    type: 'POST',
                    data: {'url': url},
                    dataType: 'json',
                    success: function(data) {
                        $('#id_title').val(data.title);
                        $('#id_isbn').val(data.isbn);
                        $('#id_authors_string').val(data.authors);
                        $('#id_year').val(data.year);
                        $('#id_publisher_name').val(data.publisher.name);
                        $('#id_publisher_id').val(data.publisher.id);
                        autofill_end();
                    },
                    error: function(xhr, textStatus, errorText) {
                        autofill_end();
                        if (xhr.status == 404) {
                            alert('Такой книги не найдено');
                        } else {
                            alert("Ошибка при общении с сервером: " + xhr.status + ": " + xhr.statusText);
                        }
                    }
                });
                return false;
            });

            var on_select_book = function(event, data, value)
            {
                $('#id_book_id').val(value.id);
                $('#id_authors_string').val(value.authors_string);
                $('#id_publisher_name').val(value.publisher__name);
                $('#id_publisher_id').val(value.publisher__id);
            }

            var on_select_publisher = function(event, data, value)
            {
                $('#id_publisher_name').val(value.name);
                $('#id_publisher_id').val(value.id);
            }

            // навешиваем автокомплит на поле "Издательство"
            $("#id_publisher_name").autocomplete(params.list_publishers_json,{
                minChars: 1,
                selectFirst: false,
                max: 20,
                width: 150,
                parse: function (data) {
                    return $.map(eval(data), function(row) {
                            return {
                                data: row.name,
                                value: row,
                                result: row.name
                            };
                    });
                    },
                formatItem: function(item) { return item; }
            }).result(on_select_publisher);

            $("#id_title").autocomplete(params.list_books_json,{
                minChars: 1,
                selectFirst: false,
                max: 20,
                width: 350,
                parse: function (data) {
                    return $.map(eval(data), function(row) {
                        return {
                            data: row.title + (row.authors_string ? ' ('+row.authors_string+')': ''),
                            value: row,
                            result: row.title
                        };
                    });
                    },
                formatItem: function(item) { return item; }
            }).result(on_select_book);
        })
    })
})(jQuery);
