function updateElementIndex(el, prefix, ndx) {
    var id_regex = new RegExp('(' + prefix + '-\\d+)');
    var replacement = prefix + '-' + ndx;
    if ($(el).attr("for")) $(el).attr("for", $(el).attr("for").replace(id_regex, replacement));
    if (el.id) el.id = el.id.replace(id_regex, replacement);
    if (el.name) el.name = el.name.replace(id_regex, replacement);
}

function addForm(btn, prefix) {
    var formCount = parseInt($('#id_' + prefix + '-TOTAL_FORMS').val());
    $('.b-book-request-section:first > .add-del-books').show(); // покажем ссылку удаления книги
    var row = $('.b-book-request-section:first').clone(true).get(0);
    $(row).removeAttr('id').insertAfter($('.b-book-request-section:last')).children('.hidden').removeClass('hidden');
    $(row).children().not(':last').children().each(function() {
        updateElementIndex(this, prefix, formCount);
        $(this).val('');
    });
    $(row).find('.errorlist').hide();
    //$(row).find('.add-del-books').show();
    $(row).find('.del-more-books').click(function() {
        deleteForm(this, prefix);
    });
    $('#id_' + prefix + '-TOTAL_FORMS').val(formCount + 1);
    $('#id_' + prefix + '-INITIAL_FORMS').val(formCount + 1);
    return false;
}

function deleteForm(btn, prefix) {
    var forms = $('.b-book-request-section');
    var forms_count = forms.length;
    if(forms_count > 1) {
        $(btn).parents('.b-book-request-section').remove();
        forms_count--;
    }
    // после удаления секции, проверим еще раз сколько осталось секций
    if(forms_count < 2) {
        $('.b-book-request-section:first > .add-del-books').hide(); // скроем ссылку удаления единственной книги
    }
    $('#id_' + prefix + '-TOTAL_FORMS').val(forms_count);
    $('#id_' + prefix + '-INITIAL_FORMS').val(forms_count);
    for (var i = 0; i < forms_count; i++) {
        $(forms.get(i)).children().not(':last').children().each(function() {
            updateElementIndex(this, prefix, i);
        });
    }
    return false;
}


(function($){
    $(function(){
        $('.b-add-request').each(function(){
            var params = this.onclick ? this.onclick() : {};

            $('input#id_book-INITIAL_FORMS').attr('autocomplete','off');  // принудительно установим счетчик форм (браузер по F5 оставляет старое знаение поля!)
            $('input#id_book-TOTAL_FORMS').attr('autocomplete','off');  // принудительно установим счетчик форм (браузер по F5 оставляет старое знаение поля!)
            $('.delete-flag > input[type="checkbox"]').attr('autocomplete','off');
            $('input[type="text"]', this).attr('autocomplete','off');

            //var first_form_del_link = $('.b-book-request-section:first > .add-del-books');
            $('.b-book-request-section:first > .add-del-books').hide();

            $('.add-more-books',this).click(function() {return addForm(this, 'book')});
            $('.del-more-books',this).click(function() {return deleteForm(this, 'book')});
        })
    })
})(jQuery);