(function($) {
    $(function() {
        $('.b-request-status-popup').click(function() {
            $(this).addClass('b-request-status-popup-open');
            var top = $(this).find('.b-request-status-item-selected')[0].offsetTop;
            $(this).css('top', -1 * top + 'px');
            $(this).mouseleave(function() {
                $(this).removeClass('b-request-status-popup-open');
                $(this).unbind('mouseleave');
                $(this).find('.b-request-status-item').unbind('click');
            });
            $('.b-request-status-item', this).click(function() {
                if (!$(this).hasClass('b-request-status-item-selected')) {
                    var old_state = $(this).parent().find('.b-request-status-item-selected')[0].onclick();
                    $(this).parent().find('.b-request-status-item').removeClass('b-request-status-item-selected');
                    $(this).addClass('b-request-status-item-selected');
                    var new_state = this.onclick();
                    var self = this;
                    $.getJSON(
                        '/orders/manage/state/',
                        {
                            request_id : $(this).parents('.b-request-status')[0].onclick(),
                            state      : new_state
                        },
                        function(data) {
                            $('.ajax-indicator').hide();
                            if(data.result == 'ok') {
                                if (new_state == 'DELIVERED') {
                                    $(self).parents('tr').addClass('delivered');
                                }
                                if (old_state == 'DELIVERED') {
                                    $(self).parents('tr').removeClass('delivered');   
                                }
                            } else {
                                document.location.reload(true);
                            }
                        }
                    );
                    $('.ajax-indicator').css('display', 'inline-block');
                }
                $(this).parent().find('.b-request-status-item').unbind('click');
                $(this).parent().removeClass('b-request-status-popup-open');
                $(this).parent().unbind('mouseleave');
                return false; // to prevent bubbling
            });
        });
        
        var YES = '&#x2713;';
        var NO  = '&#x2717;';
        //var ADD = '&#x271a;';
        $('.b-list-request-book').each(function() {
            if ($(this).hasClass('enabled')) {
                if ($(this).hasClass('b-list-request-book-approved')) {
                    $(this).prepend('<span class="b-list-request-book-control control-no" title="Убрать">' + NO + '</span>');
                } else {
                    $(this).prepend('<span class="b-list-request-book-control control-yes" title="Вернуть">' + YES + '</span>');
                }
            }
        });
        $('.b-list-request-book-control').click(function() {
            var action;
            if ($(this).hasClass('control-yes')) {
                $(this).html(NO).removeClass('control-yes').addClass('control-no').attr('title', 'Убрать');
                $(this).parents('.b-list-request-book').addClass('b-list-request-book-approved');
                action = 'positive';
            } else {
                $(this).html(YES).removeClass('control-no').addClass('control-yes').attr('title', 'Вернуть');
                $(this).parents('.b-list-request-book').removeClass('b-list-request-book-approved');
                action = 'negative'
            }
            var self = this;
            $.getJSON(
                '/orders/manage/approve/',
                {
                    book_id  : $(this).parents('.b-list-request-book')[0].onclick(),
                    action   : action
                },
                function(data) {
                    $('.ajax-indicator').hide();
                    if(data.result == 'ok') {
                        $(self).parents('.b-list-requests-item').find('.b-list-requests__price').html(data.price);
                    } else {
                        document.location.reload(true);
                    }
                }
            );
            $('.ajax-indicator').css('display', 'inline-block');
        });
    });
})
(jQuery);
