
$(function() {
    var throbbler = $('.activity');

    var hide_message = null;
    var hide_message_timeout = null;
    var show_message = function(message, prefix, className) {
        if (prefix) {
            message = prefix + ' ' + message;
        }
        $('.message_text').html(message);
        if (className) {
            $('.message').addClass(className);
        }
        var old_hide_message = function() {};
        if (hide_message) {
            old_hide_message = hide_message;
            window.clearTimeout(hide_message_timeout);
        }
        $('.message').show();
        hide_message = function() {
            $('.message').hide();
            if (className) {
                $('.message').removeClass(className);
            }
            hide_message = null;
            hide_message_timeout = null;
            old_hide_message();
        };
        hide_message_timeout = window.setTimeout(hide_message, 2000);
    };

    var show_error = function(message) {
        show_message(message, 'Возникла ошибка:', 'error');
    };
    var show_warning = function(message) {
        show_message(message, null, 'warning');
    };

    var rfid_buffer = '';
    var rfid_timer = null;
    var GREETINGS = ['Привет, ', 'Добро пожаловать, ', 'Заходи, ', 'Здравствуй, '];

    var clear_greeting_timeout = null;
    var clear_greeting = function() {
        $('.greeting').html('');
        clear_greeting_timeout = null;
    };

    var add_participant = function(info) {
        var random_idx = Math.floor(Math.random() * GREETINGS.length);
        $('.greeting').html(GREETINGS[random_idx] + info.name);
        if (clear_greeting_timeout) {
            window.clearTimeout(clear_greeting_timeout);
        }
        clear_greeting_timeout = window.setTimeout(clear_greeting, 4000);
    };

    var rfid_event = function() {
        if (rfid_buffer.length > 0) {
            $.ajax({
                url: '/crash-course/rfid/',
                method: 'POST',
                data: { rfid: rfid_buffer, date: TODAY, event_id: EVENT_ID},
                dataType: 'json',
                success: function(data) {
                    $('.activity').hide();
                    if(data.status == 'ok') {
                        add_participant(data);
                    } else if (data.status == 'error') {
                        show_warning(data.message);
                    }
                },
                error: function(xhr, status, error) {
                    $('.activity').hide();
                    if (error) {
                        show_error(error);
                    } else {
                        show_error("Попробуйте ещё раз или зовите lib@");
                    }
                }
            });
            $('.activity').show();
        }
        rfid_timer = null;
        rfid_buffer = '';
    };

    $(document).keyup(function(event) {
        if (event.keyCode > 47 && event.keyCode < 91 && !(event.metaKey || event.altKey || event.ctrlKey)) {
            rfid_buffer += String.fromCharCode(event.keyCode).toLocaleLowerCase();
            if (rfid_timer) {
                clearTimeout(rfid_timer);
            }
            rfid_timer = setTimeout(rfid_event, 500);
        }
    });
});
