//
//  Подключить общие компоненты Lego
//
include("../lego/common/block/i-common/i-common.js");
//
//  Создать родительский объект-конструктор Kiosk
//
var
    Kiosk = function(conf) {
        var
            obj = this;

        //
        //  Прочитать конфиг и "натянуть" линки на элементы,
        //  необходимые для дальнейшей работы (типа кэш элементов)
        //
        this.conf  = conf;
        this.cache = {
            back    : $('.b-kiosklib-back'),
            cancel  : $('.b-kiosklib-cancel'),
            start   : $('.b-kiosklib-choose'),
            suggest : {
                last             : null,
                global           : $('.b-kiosklib-suggest'),
                say_give_book    : $('.b-kiosklib-suggest__content__say-give-book'),
                say_give_pass    : $('.b-kiosklib-suggest__content__say-give-pass'),
                say_thank_you    : $('.b-kiosklib-suggest__content__say-thank-you'),
                say_book_exists  : $('.b-kiosklib-suggest__content__say-book-exists'),
                say_unknown_item : $('.b-kiosklib-suggest__content__say-unknown-item'),
                say_unknown_book : $('.b-kiosklib-suggest__content__say-unknown-book'),
            },
            cinema  : {
                say_give_book : $('.b-kiosklib-suggest__content__say-give-book .b-kiosklib-slides__frames'),
                say_give_pass : $('.b-kiosklib-suggest__content__say-give-pass .b-kiosklib-slides__frames')
            },
            basket  : {
                global            : $('.b-kiosklib-books-list'),
                header            : $('.b-kiosklib-books-list__h1'),
                table             : $('.b-kiosklib-books-list__table'),
                td                : $('.b-kiosklib-books-list__td_tmpl'),
                say_books_take    : $('.b-kiosklib-books-list__books_take_tmpl'),
                say_books_restore : $('.b-kiosklib-books-list__books_restore_tmpl')
            },
            buttons : {
                prev    : $('.b-button_type_prev'),
                next    : $('.b-button_type_next'),
                take    : $('.b-button_type_take'),
                restore : $('.b-button_type_restore')
            }
        };

        //
        //  Задать обработчики кликов по кнопкам
        //
        $('.b-button_type_restore').click(function(event) {
            obj.basket.mode  = 'restore';
            obj.basket.title = $(event.target).text();

            obj.screen_display('basket');
        });

        $('.b-button_type_take').click(function(event) {
            obj.basket.mode  = 'take';
            obj.basket.title = $(event.target).text();

            obj.screen_display('basket');
        });

        $('.b-button_type_cancel').click(function() {
            obj.messages_clean();
            obj.basket_clean(false);
            obj.screen_display('start');
        });

        $('.b-button_type_back').click(function() {
            obj.messages_clean();
            obj.basket_clean(false);
            obj.screen_display('start');
        });

        $('.b-button_type_prev').click(function() {
            obj.pager_go_prev();
        });

        $('.b-button_type_next').click(function() {
            obj.pager_go_next();
        });

        //
        //  Задать обработчик нажатий на клавиатуре (фильтруется
        //  все, кроме a-z и 0-9)
        //
        $(document).keyup(function(event) {
            if(event.keyCode > 47 && event.keyCode < 91) {
                obj.rfid.buffer += String.fromCharCode(event.keyCode).toLocaleLowerCase();

                if(obj.rfid.timer) {
                    clearTimeout(obj.rfid.timer);
                }

                obj.rfid.timer = setTimeout(
                    function() {
                        obj.rfid_buffer();
                    },
                    500
                );
            }
        });

        //
        //  Запустить пинговалку
        //
        this.ping.timer = setInterval(
            function() {
                obj.ping_request();
            },
            this.conf.ping_timeout
        );
    }

    //
    //  Задать свойства и методы объекта Kiosk
    //
    $.extend(Kiosk.prototype, {
        conf   : {},        //   Сюда при первом запуске копируется конфиг
        ping   : {          //   Все, что относится к "пинговалке"
            reload : false,
            timer  : null
        },
        rfid   : {          //   Все, что относится к обработке данных с rfid-сканнера
            buffer : '',
            timer  : null
        },
        cache  : {},        //   Кеш используемых html-элементов
        pager  : {          //   Все, что относится к пейджеру
            pos   : 0,
            end   : 0,
            num   : 1,
            curr  : 0,
            total : 1
        },
        screen   : {        //   Все, что относится к текущему скрину
            alias : 'start',
            timer : null
        },
        basket : {          //   Все, что относится к корзине
            total : 0,
            mode  : '',
            title : '',
            order : [],
            stack : {},
            timer : null
        },
        cinema : {          //   Анимация элементов
            loop  : 0,
            count : 0,
            name  : '',
            say_give_book : {
                times  : 'infinite',
                frames : [
                    {
                        delay : 2000,
                        top : '-220px'
                    },
                    {
                        delay : 500,
                        top : '-440px'
                    },
                    {
                        delay : 500,
                        top : '-220px'
                    },
                    {
                        delay : 500,
                        top : '-440px'
                    },
                    {
                        delay : 500,
                        top : '-220px'
                    },
                    {
                        delay : 500,
                        top : '-440px'
                    },
                    {
                        delay : 500,
                        top : '-220px'
                    },
                    {
                        delay : 1000,
                        top : '0'
                    }
                ]
            },
            say_give_pass : {
                times  : 1,
                frames : [
                    {
                        delay : 500,
                        top : '-220px'
                    },
                    {
                        delay : 500,
                        top : '0'
                    },
                    {
                        delay : 500,
                        top : '-220px'
                    },
                    {
                        delay : 500,
                        top : '0'
                    },
                    {
                        delay : 500,
                        top : '-220px'
                    },
                    {
                        delay : 500,
                        top : '0'
                    },
                    {
                        delay : 500,
                        top : '-220px'
                    },
                    {
                        delay : 500,
                        top : '0'
                    },
                    {
                        delay : 500,
                        top : '-220px'
                    }
                ]
            },
            timer : null
        },
        //
        //  Послать пинг-запрос серваку на предмет наличия обновлений.
        //  Если ключик action приходит в значении reload, то страница
        //  обновляется
        //
        ping_request : function() {
            var
                obj = this;

            $.getJSON(
                this.conf.url_ping,
                {},
                function(data) {
                    if(data.action == 'reload') {
                        obj.ping.reload = true;
                    } else {
                        obj.ping.reload = false;
                    }
                }
            );

            if(this.ping.reload && this.screen.alias == 'start') {
                window.location.reload();
            }
        },
        //
        //  Отобразить нужный "экран"
        //
        screen_display : function(screen) {
            var
                obj = this;

            switch(screen) {
                case 'start':
                    this.screen.alias = 'start';

                    this.cache.start.removeClass('g-hidden');

                    this.cache.back.addClass('g-hidden');
                    this.cache.cancel.addClass('g-hidden');
                    this.cache.basket.global.addClass('g-hidden');
                    this.cache.suggest.global.css('display', 'none');

                    if(this.basket.timer) {
                        clearTimeout(this.basket.timer);
                    }

                    this.cinema_stop();
                    break;
                case 'basket':
                    this.screen.alias = 'basket';

                    this.cache.start.addClass('g-hidden');
                    this.cache.cancel.removeClass('g-hidden');
                    this.cache.basket.global.removeClass('g-hidden');

                    this.cache.basket.header.text(this.basket.title);

                    this.cache.suggest.global.fadeIn(this.conf.fading_speed);
                    this.messages_display('say_give_book');

                    this.screen_timeout();
                    break;
            }
        },
        //
        //  Устанавливает для скрина таймаут
        //
        screen_timeout : function() {
            var
                obj = this;

            if(this.screen.timer) {
                clearTimeout(this.screen.timer);
            }

            this.screen.timer = setTimeout(
                function() {
                    obj.basket_clean(false);
                    obj.screen_display('start');
                },
                this.conf.screen_timeout
            );
        },
        //
        //  Инициализировать пейджер
        //
        pager_init : function(refresh) {
            if(refresh || this.pager.pos < 0) {
                this.pager.pos = 0; //  начальная позиция для чтения корзины
            }

            this.pager.end = this.pager.pos + this.conf.books_per_page; //  конечная позиция для чтения корзины

            if(this.pager.end > this.basket.total) {
                this.pager.end = this.basket.total;
            }

            this.pager.curr  = Math.ceil(this.pager.pos / this.conf.books_per_page) + 1; //  номер текущей страницы
            this.pager.total = Math.ceil(this.basket.total / this.conf.books_per_page);  //  общее количество страниц

            if(
                this.pager.pos == 0 ||
                this.pager.total == 1
            ) {
                this.cache.buttons.prev.addClass('g-hidden');
            } else {
                this.cache.buttons.prev.removeClass('g-hidden');
            }

            if(
                this.pager.end == this.basket.total ||
                this.pager.total == 1
            ) {
                this.cache.buttons.next.addClass('g-hidden');
            } else {
                this.cache.buttons.next.removeClass('g-hidden');
            }
        },
        //
        //  Сбросить все настройки пейджера
        //
        pager_clean : function() {
            this.pager.pos   = 0;
            this.pager.end   = 0;
            this.pager.curr  = 1;
            this.pager.total = 1;

            if(!this.cache.buttons.prev.hasClass('g-hidden')) {
                this.cache.buttons.prev.addClass('g-hidden');
            }

            if(!this.cache.buttons.next.hasClass('g-hidden')) {
                this.cache.buttons.next.addClass('g-hidden');
            }
        },
        //
        //  Перейти на предыдущую страницу в корзине
        //
        pager_go_prev : function() {
            this.pager.pos = this.pager.pos - this.conf.books_per_page;

            this.pager_init(false);
            this.basket_display();
        },
        //
        //  Перейти на следующую страницу в корзине
        //
        pager_go_next : function() {
            this.pager.pos = this.pager.pos + this.conf.books_per_page;

            this.pager_init(false);
            this.basket_display();
        },
        //
        //  Обработать rfid-эмуляции нажатия клавиш
        //
        rfid_buffer : function() {
            clearTimeout(this.rfid.timer);
            this.rfid.timer = null;

            if(this.rfid.buffer.length > 0) {
                if(this.rfid.buffer == 'admin') {
                    alert('Кто, ну кто тут, к примеру, в админы крайний? Никого? Так я первым буду!');
                } else {
                    //
                    //  запрос к RFID
                    //
                    this.rfid_request(this.rfid.buffer);
                }
            }

            this.rfid.buffer = '';
        },
        //
        //  Послать rfid-данные для обработки на сервер
        //
        rfid_request : function(request) {
            var
                obj = this;

            $.getJSON(
                this.conf.url_rfid,
                {
                    rfid   : request,
                    screen : obj.screen.alias
                },
                function(data) {
                    if(data.result == 'ok' || obj.screen.alias == 'start') {
                        obj['rfid_handler_' + obj.screen.alias](data);
                    } else {
                        obj.messages_display('say_unknown_item');
                    }
                }
            );
        },
        //
        //  Пока не используется
        //
        rfid_handler_start : function(data) {
            var
                obj = this;

            this.cache.buttons.take.addClass('b-button_attention');
            this.cache.buttons.restore.addClass('b-button_attention');

            setTimeout(
                function() {
                    obj.cache.buttons.take.removeClass('b-button_attention');
                    obj.cache.buttons.restore.removeClass('b-button_attention');
                },
                this.conf.messages_timeout
            );
        },
        //
        //  Подключить обработчик информации о пользователе
        //
        rfid_handler_basket : function(data) {
            switch(data.type) {
                case 'book':
                    this.basket_add(data);
                    break;
                case 'user':
                    this.basket_assign(data);
                    break;
                default:
                    this.messages_display('say_unknown_book');
                    break;
            }
        },
        //
        //  Добавить книгу в корзину
        //
        basket_add : function(data) {
            if(!this.basket.stack[data.bookitem_id]) {
                this.basket.stack[data.bookitem_id] = {
                    cover   : data.book_cover_url,
                    title   : this.basket_crop_by_words(data.book_title),
                    authors : data.book_authors,
                    scase  : data['case'],
                    shelf   : data.shelf
                }

                this.basket.order.unshift(data.bookitem_id);

                this.basket.total++;

                this.pager_init(true);
                this.basket_display();
            } else {
                this.messages_display('say_book_exists');
            }
        },
        //
        //  Удалить книгу из корзины
        //
        basket_remove : function(element) {
            var
                td  = $(element).parent(),
                bid = (td.attr('id').replace(/book_id_/, '')) - 0,  //  иначе inArray() не будет находить элемент
                pos = $.inArray(bid, this.basket.order);

            if(this.basket.stack[bid] && pos > -1) {
                delete this.basket.stack[bid];

                this.basket.order.splice(pos, 1);

                this.basket.total--;

                this.pager_init(true);
                this.basket_display();
            }
        },
        //
        //  При поднесении пропуска, если в корзине что-нибудь
        //  есть, отправить список книг обработчику на сервер
        //
        basket_assign : function(data) {
            if(this.basket.total > 0) {
                var
                    obj    = this,
                    params = {
                        mode        : this.basket.mode,
                        books       : this.basket.order,
                        login       : data.login,
                        rfid_number : data.rfid_number
                    };

                $.post(
                    this.conf.url_basket_action,
                    params,
                    function(data) {
                        var
                            cnt = data.success_count;

                        obj.cache.basket.header.html(obj.cache.basket['say_books_' + (obj.basket.mode)].html());
                        obj.cache.suggest.global.hide();
                        obj.cache.cancel.addClass('g-hidden');
                        obj.cache.back.removeClass('g-hidden');

                        obj.basket.timer = setTimeout(
                            function() {
                                obj.screen_display('start');
                            },
                            obj.conf.thank_you_timeout
                        );

                        obj.basket_clean(false);
                    },
                    'json'
                );
            }
        },
        //
        //  Показать содержимое корзины, если там что-нибудь есть
        //
        basket_display : function() {
            var
                obj = this;

            this.basket_clean(true);
            this.screen_timeout();

            if(this.basket.total > 0) {
                this.messages_display('say_give_pass');

                for(var book = this.pager.pos; book < this.pager.end; book++) {
                    var
                        id      = this.basket.order[book],
                        item    = this.basket.stack[this.basket.order[book]],
                        tpl     = $(this.cache.basket.td).clone(),
                        td      = $('.b-kiosklib-books-list__td', tpl),
                        cover   = {},
                        title   = $('.b-kiosklib-books-list__title', tpl),
                        authors = $('.b-kiosklib-books-list__authors', tpl),
                        shelf   = $('.b-kiosklib-books-list__shelf', tpl);

                    cover.div = $('.b-kiosklib-books-list__cover', tpl);
                    cover.img = $('.b-kiosklib-books-list__cover__img', cover.div);

                    td.attr('id', 'book_id_' + this.basket.order[book]);
                    title.text(item.title);

                    if(item.authors) {
                        authors.text(item.authors);
                    }

                    if(item.cover) {
                        cover.div.removeClass('g-hidden');
                        cover.img.attr('src', item.cover);
                    }

                    if (item.scase && item.shelf) {
                        shelf.text('Шкаф ' + item.scase + ', полка ' + item.shelf);
                    }

                    this.cache.basket.table.append(tpl.html());
                }

                this.cache.basket.table.removeClass('g-hidden');

                $('.b-kiosklib-books-list__delete').click(function() {
                    obj.basket_remove(this);
                });
            } else {
                this.messages_display('say_give_book');
                this.basket_clean(false);
            }
        },
        //
        //  Если строка длиннее
        //
        basket_crop_by_words : function(title) {
            if(title.length > this.conf.letters_per_item) {
                var
                    str   = title.substr(0, this.conf.letters_per_item),
                    words = str.split(/ /);

                words.pop();

                title = (words.join(' ').replace(/(\.|,|:|;)$/, '')) + '...';
            }

            return(title);
        },
        //
        //  Очистить корзину визуально и, если необходимо, буквально
        //
        basket_clean : function(dry) {
            if(!dry) {
                this.basket.total = 0;
                this.basket.order  = [];
                this.basket.stack = {};

                this.pager_clean();
            }

            this.cache.basket.table.empty();
            this.cache.basket.table.addClass('g-hidden');
        },
        //
        //  Спрятать в блоке подсказки показанные ранее блоки
        //
         messages_clean : function() {
            if(
                this.cache.suggest.last != '' &&
                this.cache.suggest[this.cache.suggest.last]
            ) {
                this.cache.suggest[this.cache.suggest.last].css('display', 'none');

                this.cache.suggest.last = '';
            }
         },
        //
        //  Отобразить сообщение в блоке подсказки
        //
        messages_display : function(type) {
            var
                obj = this;

            if(
                type != this.cache.suggest.last
            ) {
                this.messages_clean();
            }

            if(
                this.cache.suggest[type].css('display') == 'none' &&
                type != this.cache.suggest.last
            ) {
                if(
                    type == 'say_unknown_item' ||
                    type == 'say_unknown_book' ||
                    type == 'say_book_exists'
                ) {
                    this.cache.suggest.global.addClass('b-kiosklib-suggest_error');
                } else {
                    this.cache.suggest.global.removeClass('b-kiosklib-suggest_error');
                }

                if(
                    type != 'say_give_book' &&
                    type != 'say_give_pass'
                ) {
                    this.cache.suggest[type].fadeIn(
                        this.conf.fading_speed,
                        function() {
                            setTimeout(
                                function() {
                                    if(obj.basket.total > 0) {
                                        obj.messages_display('say_give_pass');
                                    } else {
                                        obj.messages_display('say_give_book');
                                    }
                                },
                                obj.conf.messages_timeout
                            );
                        }
                    );
                } else {
                    this.cache.suggest[type].fadeIn(
                        this.conf.fading_speed,
                        function() {
                            obj.cinema_stop();
                            obj.cinema_play(type);
                        }
                    );
                }

                this.cache.suggest.last = type;
            }
        },
        //
        //  Включить анимацию в текущей подсказке
        //
        cinema_play : function(name) {
            var
                len   = this.cinema[name].frames.length,
                last  = len - 1,
                frame = this.cinema.loop,
                obj   = this;

            this.cinema.name = name;

            if(
                this.cinema[name].times == 'infinite' ||
                this.cinema.count < this.cinema[name].times
            ) {
                this.cinema.timer = setTimeout(
                    function() {
                        (function(frame) {
                            obj.cache.cinema[name].css('top', obj.cinema[name].frames[frame].top);
                            obj.cinema_play(name);
                        })(frame);
                    },
                    obj.cinema[name].frames[frame].delay
                );
            }

            if(this.cinema.loop >= last) {
                this.cinema.loop = 0;
                this.cinema.count++;
            } else {
                this.cinema.loop++;
            }
        },
        //
        //  Выключить включенную ранее анимацию в подсказке
        //
        cinema_stop : function() {
            if(this.cinema.timer != null) {
                this.cache.cinema[this.cinema.name].css('top', '0');

                clearTimeout(this.cinema.timer);

                this.cinema.loop  = 0;
                this.cinema.count = 0;
                this.cinema.name  = '';
                this.cinema.timer = null;
            }
        }
    });
