var url_staff_list_json = "/service/stafflist?fields=first_name|last_name|login_ld";
var url_list_publishers_json = "";
var url_list_books_json = "";

// --- add-book-form ---

var parser_function = function (data) {
	return $.map(eval(data), function(row) {
		if (row.login_ld) {
			return {
				data: row.first_name + " " + row.last_name + (row.login_ld ? " (" + row.login_ld + (row.work_phone?", "+row.work_phone:"") + ")" : ""),
				value: row,
				result: row.first_name + " " + row.last_name
			};
		} else {
			return false;
		}
	});
	};

var staff_autocomplete_params = {
		url: url_staff_list_json,
		minChars: 1,
		selectFirst: false,
		max: 20,
		width: 250,
		parse: parser_function,
		formatItem: function(item) { return item; }
	}

function on_change_ownership(event)
{
	var val = event.target.value;
	if (val == 'PR')
		$("#id_owner_tr").show();
	else
		$("#id_owner_tr").hide();
}

function on_change_location(event)
{
	var val = event.target.value;
	switch (val)
	{
		case 'onhands':
			$("#id_location_staff_tr").show();
			$("#id_location_string_tr").hide();
			break;
		case 'lib':
			$("#id_location_staff_tr").hide();
			$("#id_location_string_tr").show();
			break;
	}
}

function on_select_book(event, data, value)
{
	$('#id_book_id').val(value.id);
	$('#id_authors_string').val(value.authors_string);
	$('#id_publisher_name').val(value.publisher__name);
	$('#id_publisher_id').val(value.publisher__id);
}

function on_select_publisher(event, data, value)
{
	$('#id_publisher_name').val(value.name);
	$('#id_publisher_id').val(value.id);
}

function add_book_initialize()
{
	// Навешиваем обработчик смены типа "где находится"
	$(".location_widget").bind("click", on_change_location);
	$(".location_widget").click();
	
	// Навешиваем обработчик смены типа владения
	if(add_my_book == false)
	{
		$("#id_ownership_choices").bind("change", on_change_ownership);
		$("#id_ownership_choices").change();
	}
	else
	{
		$("#id_ownership_tr, #id_owner_tr").hide();	// уберем секцию выбора владельца 
	}
	
	// Навешиваем автокомплит на поле "Владелец книги" и если сотрудник выбран, запоминаем ФИ+(логин) в скрытом поле
	$( "input#id_owner" ).autocomplete( staff_autocomplete_params ).bind(
			'result', function( event, value, formatted ) {
				var re = /.*\((\S+)\)/
				var login = re.exec(value)[1]
				$( "#id_owner_staff_login" ).val( login );
			}
	 );

	// Навешиваем автокомплит на поле "У кого книга" и если сотрудник выбран, запоминаем ФИ+(логин) в скрытом поле
	$( "input#id_location_staff" ).autocomplete( staff_autocomplete_params ).bind(
			'result', function( event, value, formatted ) {
				var re = /.*\((\S+)\)/
				var login = re.exec(value)[1]
				$( "#id_location_staff_login" ).val( login );
			}
	 );

	 // навешиваем автокомплит на поле "Издательство"
	var publ_autocomplete_params = {
			url: url_list_publishers_json,
			minChars: 1,
			selectFirst: false,
			max: 20,
			width: 150,
			parse: function (data) {
				return $.map(eval(data), function(row) {
						return {
							data: row.name,
							value: row,
							result: row.name
						};
				});
				},
			formatItem: function(item) { return item; },
			result: on_select_publisher
		};
	$( "input#id_publisher_name" ).autocomplete( publ_autocomplete_params );

	 // навешиваем автокомплит на поле "Название книги"
	var book_acompl_params = {
			url: url_list_books_json,
			minChars: 1,
			selectFirst: false,
			max: 20,
			width: 350,
			parse: function (data) {
				return $.map(eval(data), function(row) {
						return {
							data: row.title + (row.authors_string ? ' ('+row.authors_string+')': ''),
							value: row,
							result: row.title
						};
				});
				},
			formatItem: function(item) { return item; },
			result: on_select_book
		};
	$( "input#id_title" ).autocomplete( book_acompl_params );
}
// --- add-book-form END ---

// --- view-book-form -------------------------
// переменной data все занчения присваиваются в шаблоне (джанго-тегами)
function post_and_expand() {
	// Отправляет на сервер признак "я читал" и разворачивает форму для отзыва
	$("#iread_lnk").unbind("click"); // Отвязываем этот обработчик от последующих кликов
	post_opinion();
	$("#iread_lnk").bind('click',( function() { $("#opinion_block").toggle(); } )); // вешаем новый обработчик: сворачивание/разворачивание формы отзыва
	$("#opinion_block").show();
	$("#iread_lnk").text(data.texts_you_have_read_give_your_opinion);
}

function post_opinion() {
	// {# сохраняет текст отзыва в БД и меняет текст ссылки #}
	$.post(data.url_iread_book_data_book_id, { read: 1, opinion_text:$("#opinion_text").val()}); //{# отправляем POST-запрос на сервер: "эту книгу чувак читал" #}
	$("#iread_lnk").text(data.texts_we_have_your_opinion);
}

function idont_read_it() {
	$.post(data.url_iread_book_data_book_id, { read: 0 }); //{# отправляем POST-запрос на сервер: "эту книгу чувак НЕ читал" #}
	$("#iread_lnk").text(data.texts_wow_i_have_read_this_book);
	$("#opinion_text").val('');
	$("#opinion_block").hide();
	$("#iread_lnk").bind("click",post_and_expand);
}



// --- view-book-form END ---------------------
