
$(function() {

    var throbbler = $('.activity');

    var hide_message = null;
    var hide_message_timeout = null;
    var show_message = function(message, prefix, className) {
        if (prefix) {
            message = prefix + ' ' + message;
        }
        $('.message_text').html(message);
        if (className) {
            $('.message').addClass(className);
        }
        var old_hide_message = function() {};
        if (hide_message) {
            old_hide_message = hide_message;
            window.clearTimeout(hide_message_timeout);
        }
        $('.message').show();
        hide_message = function() {
            $('.message').hide();
            if (className) {
                $('.message').removeClass(className);
            }
            hide_message = null;
            hide_message_timeout = null;
            old_hide_message();
        };
        hide_message_timeout = window.setTimeout(hide_message, 4000);
    };

    var show_error = function(message) {
        show_message(message, 'Возникла ошибка:', 'error');
    };
    var show_warning = function(message) {
        show_message(message, null, 'warning');
    };

    var show_state = function(name) {
        $('.state').hide();
        $('.state-' + name).show();
    };

    var current_device = null;

    var rfid_buffer = '';
    var rfid_timer = null;

    var handlers = {
        active: {},
        start: {
            person: function(data) {
                current_user = data;
                $('.greetings-hi span').html(data.login);
                show_state('hi');
                $('.action-cancel').unbind('click');
                $('.action-cancel').click(function() {
                    current_user = null;
                    show_state('start');
                    $('.action-cancel').unbind('click');
                    handlers.active.device = handlers.start.device;
                });
                handlers.active.device = handlers.person.device;
            },
            device: function(data) {
                current_device = data;
                $('.device-name').html(data.device);
                if (data.holder) {
                    $('.device-holder span').html(data.holder + '@');
                    $('.device-holder').show();
                } else {
                    $('.device-holder').hide();
                }
                show_state('device');
                $('.action-cancel').unbind('click');
                $('.action-cancel').click(function() {
                    current_device = null;
                    show_state('start');
                    $('.action-cancel').unbind('click');
                    handlers.active.person = handlers.start.person;
                });
                handlers.active.person = handlers.device.person;
            }
        },
        person: {
            device: function(data) {
                current_device = data;
                handlers.device.person(current_user);
            }
        },
        device: {
            person: function(data) {
                current_user = data;
                var returning = current_device.holder == current_user.login;
                $('.pick-device').html(current_device.device);
                $('.pick-future').hide();
                $('.future-take').show();
                $('.action-confirm').html('Взять');
                if (current_device.holder) {
                    if (returning) {
                        $('.pick-current span').html('вас');
                        $('.pick-current').show();
                        $('.pick-future').hide();
                        $('.future-return').show();
                        $('.action-confirm').html('Вернуть');
                    } else {
                        $('.pick-current span').html(current_device.holder + '@');
                        $('.pick-current').show();
                    }
                } else {
                    $('.pick-current').hide();
                }
                $('.pick-future span').html(data.login);
                show_state('pick');
                $('.action-cancel').unbind('click');
                $('.action-cancel').click(function() {
                    current_device = null;
                    current_user = null;
                    show_state('start');
                    $('.action-cancel').unbind('click');
                    handlers.active.person = handlers.start.person;
                    handlers.active.device = handlers.start.device;
                });
                var processing = false;
                var url = '/devices/take/';
                if (returning) {
                    url = '/devices/return/';
                }
                $('.action-confirm').unbind('click');
                $('.action-confirm').click(function() {
                    if (processing) return;
                    $.post(url,
                        { device: current_device.rfid,
                          user: current_user.rfid },
                        function(data) {
                            $('.activity').hide();
                            if (data.status == 'ok') {
                                if (returning) {
                                    show_message("Спасибо, что вернули");
                                } else {
                                    show_message("Пользуйтесь на здоровье");
                                }
                                current_device = null;
                                current_user = null;
                                show_state('start');
                                handlers.active.person = handlers.start.person;
                                handlers.active.device = handlers.start.device;
                            } else if (data.status == 'error') {
                                show_error("Попробуйте ещё раз или зовите lib@");
                                processing = false;
                            }
                        }, "json"
                    );
                    processing = true;
                    $('.activity').show();
                });
            }
        }
    };
    handlers.active.person = handlers.start.person;
    handlers.active.device = handlers.start.device;

    var rfid_event = function() {
        if (rfid_buffer.length > 0) {
            $('.current-rfid').html(rfid_buffer);
            $.ajax({
                url: '/devices/rfid/',
                data: { rfid: rfid_buffer },
                dataType: 'json',
                success: function(data) {
                    $('.activity').hide();
                    if(data.status == 'ok') {
                        if (data.type == 'person') {
                            handlers.active.person(data);
                        }
                        if (data.type == 'device') {
                            handlers.active.device(data);
                        }
                    } else if (data.status == 'error') {
                        show_warning(data.message);
                    }
                },
                error: function(xhr, status, error) {
                    $('.activity').hide();
                    if (error) {
                        show_error(error);
                    } else {
                        show_error("Попробуйте ещё раз или зовите lib@");
                    }
                }
            });
            $('.activity').show();
        }
        rfid_timer = null;
        rfid_buffer = '';
    };

    $('.action-take').click(function() {
        show_state('take');
        $('.action-cancel').unbind('click');
        $('.action-cancel').click(function() {
            show_state('start');
        });
    });
    $('.action-return').click(function() {
        show_state('return');
        $('.action-cancel').unbind('click');
        $('.action-cancel').click(function() {
            show_state('start');
        });
    });

    $(document).keyup(function(event) {
        if (event.keyCode > 47 && event.keyCode < 91) {
            rfid_buffer += String.fromCharCode(event.keyCode).toLocaleLowerCase();
            if (rfid_timer) {
                clearTimeout(rfid_timer);
            }
            rfid_timer = setTimeout(rfid_event, 500);
        }
    });
});
