<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-bigform"/>
<xsl:template match="lego:b-auth-bigform[not(lego:auth())]">
    <form>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:form-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </form>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-bigform" mode="lego:block-class-js">
    <xsl:text> g-js</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-bigform" mode="lego:action-content">
    <xsl:value-of select="$lego:params/lego:passport-host"/>
    <xsl:text>/passport?mode=auth&amp;msg=</xsl:text>
    <xsl:value-of select="x:urlencode('utf-8', $lego:params/lego:passport-msg)"/>
    <xsl:if test="$lego:params/lego:retpath">
        <xsl:text>&amp;retpath=</xsl:text><xsl:value-of select="x:urlencode('utf-8', $lego:params/lego:retpath)"/>
    </xsl:if>    
</xsl:template>

<xsl:template match="lego:b-auth-bigform" mode="lego:method-content">
    <xsl:text>post</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-bigform" mode="lego:content">
    <table class="shadow">
        <tr>
            <td class="lt"/>
            <td/>
            <td class="rt"/>
        </tr>
        <tr>
            <td class="l"/>
            <td>
                <xsl:apply-templates select="." mode="lego:logo"/>
                <div class="form">
                    <xsl:apply-templates select="lego:title"/>
                    <xsl:apply-templates select="lego:username"/>
                    <xsl:apply-templates select="lego:password"/>
                    <xsl:apply-templates select="." mode="lego:permanent"/>
                    <xsl:apply-templates select="." mode="lego:submit"/>
                    <xsl:apply-templates select="." mode="lego:remember"/>
                    <xsl:apply-templates select="lego:register"/>
                </div>
            </td>
            <td class="r"/>
        </tr>
        <tr>
            <td class="lb"><i/></td>
            <td class="b"/>
            <td class="rb"><i/></td>
        </tr>
    </table>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-bigform" mode="lego:logo">
    <div class="logo">
        <a href="http://www.yandex.ru">
            <img alt="{lego:message('b-head-logo-yandex', 'Яндекс')}">
                <xsl:apply-templates select="." mode="lego:src"/>
            </img>
        </a>
    </div>
</xsl:template>

<xsl:template match="lego:b-auth-bigform" mode="lego:src-content">
    <xsl:value-of select="concat($lego:lego-static-host, '/common/block/b-auth-bigform/b-auth-bigform__logo.png')"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-bigform/lego:title">
    <div class="title">
        <xsl:apply-templates/>
    </div>
</xsl:template>

<xsl:template match="lego:b-auth-bigform" mode="lego:permanent">
    <div class="permanent">
        <input id="b-auth-bigform-permanent" name="twoweeks" type="checkbox" value="yes" tabindex="122"/>
        <label for="b-auth-bigform-permanent">
            <xsl:value-of select="lego:message('b-auth-bigform-permanent', 'Запомнить меня')"/>
        </label>
    </div>
</xsl:template>

<xsl:template match="lego:b-auth-bigform" mode="lego:submit">
    <div class="button">
        <input type="submit" value="{lego:message('b-auth-bigform-enter', 'Войти')}" tabindex="123"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-auth-bigform" mode="lego:remember">
    <div class="remember">
        <a href="{$lego:params/lego:passport-host}/passport?mode=remember" tabindex="125">
            <xsl:value-of select="lego:message('b-auth-bigform-remember', 'Вспомнить пароль')"/>
        </a>
    </div>
</xsl:template>

<xsl:template match="lego:b-auth-bigform/lego:register">
    <div class="register" tabindex="124">
        <a>
            <xsl:apply-templates select="." mode="lego:url"/>
            <xsl:apply-templates select="." mode="lego:text"/>
        </a>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-bigform/lego:username | lego:b-auth-bigform/lego:password">
    <div class="{local-name()}">
        <xsl:apply-templates select="lego:input"/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-bigform//lego:input">
    <xsl:apply-templates select="lego:hint"/>
    <div class="b-input">
        <input>
            <xsl:apply-templates select="." mode="lego:attributes"/>
            <xsl:apply-templates select="." mode="lego:input-attributes"/>
        </input>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-bigform//lego:input[lego:hint]" mode="lego:id-content">
    <xsl:value-of select="concat('b-auth-bigform-', local-name(..))"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-bigform//lego:input[@name = 'login']" mode="lego:tabindex-content">
    <xsl:text>120</xsl:text>
</xsl:template>

<xsl:template match="lego:b-auth-bigform//lego:input[@name = 'passwd']" mode="lego:tabindex-content">
    <xsl:text>121</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-bigform/lego:username/lego:input/lego:hint/lego:b-hint-input[. = '']" mode="lego:content">
    <xsl:value-of select="lego:message('b-auth-bigform-username', 'логин')"/>
</xsl:template>

<xsl:template match="lego:b-auth-bigform/lego:password/lego:input/lego:hint/lego:b-hint-input[. = '']" mode="lego:content">
    <xsl:value-of select="lego:message('b-auth-bigform-password', 'пароль')"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-bigform/lego:register" mode="lego:url-content">
    <xsl:value-of select="$lego:params/lego:passport-host"/>
    <xsl:text>/passport?mode=register&amp;from=</xsl:text><xsl:value-of select="$lego:id"/>
    <xsl:if test="$lego:params/lego:yandexuid">
        <xsl:text>&amp;yu=</xsl:text><xsl:value-of select="$lego:params/lego:yandexuid"/>
    </xsl:if>
    <xsl:if test="$lego:params/lego:retpath">
        <xsl:text>&amp;retpath=</xsl:text><xsl:value-of select="x:urlencode('utf-8', $lego:params/lego:retpath)"/>
    </xsl:if>
    <xsl:if test="$lego:params/lego:passport-msg">
        <xsl:text>&amp;msg=</xsl:text><xsl:value-of select="x:urlencode('utf-8', $lego:params/lego:passport-msg)"/>
    </xsl:if>
</xsl:template>

<xsl:template match="lego:b-auth-bigform/lego:register" mode="lego:text">
    <xsl:value-of select="."/>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

