(function($, Lego) {

Lego.block['b-auth-domik_popup'] = function(params) {

    var thisHolder = $(this), popup;

    // навешиваемся на ссылку "войти"
    $('.b-head-userinfo__entry .b-pseudo-link').click(function() {
        show();
        return false;
    });

    function show(retpath) {
        if(!popup) init();
        var urlParams = '&from=' + Lego.params['passport-msg'] +
            '&retpath=' + encodeURIComponent(retpath || Lego.params['retpath']);
        popup
            .attr('action', Lego.params['passport-host'] + '/passport?mode=auth' + urlParams)
            .find('.b-auth-domik__register .b-auth-domik__link')
                .attr('href', Lego.params['passport-host'] + '/passport?mode=' +
                    (params.regMode || 'register') + urlParams);
        $(document)
             // скрываем по esc
            .bind('keyup.b-auth-domik', function(e) { if(e.keyCode == 27) { hide(); }})
            // скрываем по клику вне попапа
            .bind('click.b-auth-domik', function(e) {
                if($(e.target).parents().andSelf().index(popup) == -1 || $(e.target).is('input[type=button]')) {
                    hide();
                }
            });        
        !popup.hasClass('b-auth-domik_popup-50-50') && window.scrollTo(0, 0);
        popup
            .show()
            .find('input[name=login]').focus();
        $(document).trigger('show.b-auth-domik_popup');
    };

    function hide() {
        $(document).unbind('.b-auth-domik');
        popup.hide();
    }

    function init() { // вспомогательная ф-ия, создающая элемент попапа при первом открытии попапа
        popup = $(
            '<form class="' + thisHolder.attr('class').replace('g-hidden', '') +  '" method="post">' +
                '<i class="b-auth-domik__roof"></i>' +
                '<table class="b-auth-domik__shadow">' +
                '<tr>' +
                    '<td class="b-auth-domik__shadow__lt">&nbsp;</td>' +
                    '<td class="b-auth-domik__shadow__t"></td>' +
                    '<td class="b-auth-domik__shadow__rt">&nbsp;</td>' +
                '</tr>' +
                '<tr>' +
                    '<td class="b-auth-domik__shadow__l">&nbsp;</td>' +
                    '<td class="b-auth-domik__shadow__m">' +
                        '<div class="b-auth-domik__form">' +
                            '<div class="b-auth-domik__title">' + params.title + '</div>' +
                            '<div class="b-auth-domik__username">' +
                                '<label for="b-auth-domik_popup-username" class="b-hint-input g-js" onclick="return {name:\'b-hint-input\'}">' +
                                    Lego.message('b-auth:login', 'логин') +
                                '</label>' +
                                '<div class="b-input"><input class="b-input__text" id="b-auth-domik_popup-username" name="login" tabindex="11"/></div>' +
                            '</div>' +
                            '<div class="b-auth-domik__password">' +
                                '<label for="b-auth-domik_popup-password" class="b-hint-input g-js" onclick="return {name:\'b-hint-input\'}">' +
                                    Lego.message('b-auth:password', 'пароль') +
                                 '</label>' +
                                '<div class="b-input"><input class="b-input__text" id="b-auth-domik_popup-password" name="passwd" type="password" tabindex="11"/></div>' +
                            '</div>' +
                            '<div class="b-auth-domik__permanent">' +
                                '<input class="b-auth-domik__check" id="b-auth-domik_popup-permanent" name="twoweeks" type="checkbox" value="yes" tabindex="11"/>' +
                                '<label for="b-auth-domik_popup-permanent">' +
                                    Lego.message('b-auth:permanent', 'Запомнить меня') +
                                '</label> ' +
                                '<span class="b-auth-domik__help">(<a class="b-auth-domik__link" href="http://help.yandex.ru/passport/?id=922493" tabindex="12">' +
                                    Lego.message('b-auth:help', 'что&nbsp;это') +
                                '</a>)</span>' +
                            '</div>' +
                            '<div class="b-auth-domik__button">' +
                                '<input class="b-auth-domik__submit" type="submit" value="' +
                                    Lego.message('b-auth:logon', 'Войти') +
                                '" tabindex="11"/>' +
                                '<input class="b-auth-domik__submit" type="button" value="' +
                                    Lego.message('b-auth:cancel', 'Отмена') +
                                '" tabindex="11"/>' +
                            '</div>' +
                            '<div class="b-auth-domik__register">' +
                                '<a class="b-auth-domik__link" href="" tabindex="11">' +
                                    (params.register || Lego.message('b-auth:register', 'Зарегистрироваться')) +
                                '</a>' +
                            '</div>' +
                            '<div class="b-auth-domik__remember">' +
                                '<a class="b-auth-domik__remind" href="' + Lego.params['passport-host'] + '/passport?mode=remember" tabindex="11">' +
                                    Lego.message('b-auth:remember', 'Напомнить пароль') +
                                '</a>' +
                            '</div>' +
                        '</div>' +
                    '</td>' +
                    '<td class="b-auth-domik__shadow__r">&nbsp;</td>' +
                '</tr>' +
                '<tr>' +
                    '<td class="b-auth-domik__shadow__lb">&nbsp;</td>' +
                    '<td class="b-auth-domik__shadow__b"></td>' +
                    '<td class="b-auth-domik__shadow__rb">&nbsp;</td>' +
                '</tr>' +
                '</table>' +
                '<iframe class="b-popup-under"></iframe>' +
            '</form>');
            if(Lego.block['b-auth']) {
                Lego.block['b-auth'].call(popup);
            }
            $('body').append(popup);
            Lego.blockInit(popup);
    };

    arguments.callee.login = show; // ф-ия для открытия попапа извне Lego.block['b-auth-domik_popup'].login()

};

})(jQuery, window.Lego);
