<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-domik"/>

<xsl:template match="lego:b-auth-domik[not(lego:auth()) and @lego:type = 'onpage']">
    <table>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
    <tr>
        <td class="b-auth-domik_onpage__max">
            <form class="b-auth-domik__i">
                <xsl:apply-templates select="." mode="lego:form-attributes"/>
                <div class="b-auth-domik__wrap-roof"><i class="b-auth-domik__roof"/></div>
                <xsl:apply-templates select="." mode="lego:content"/>
            </form>
            <xsl:text disable-output-escaping="yes">&lt;!--[if lt IE 8]&gt;</xsl:text>
                <div class="b-auth-domik_onpage__gap"/>
            <xsl:text disable-output-escaping="yes">&lt;![endif]--&gt;</xsl:text>
        </td>
    </tr>
    </table>
</xsl:template>

<xsl:template match="lego:b-auth-domik[not(lego:auth()) and @lego:type = 'popup']">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-domik" mode="lego:block-class-js">
    <xsl:text> g-js</xsl:text>
    <xsl:if test="@lego:type = 'popup'"> g-hidden</xsl:if>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-domik" mode="lego:js-params-content">
    <xsl:text>name:</xsl:text><xsl:value-of select="x:js-quote(concat(lego:name(.), '_', @lego:type))"/>
    <xsl:if test="@lego:type = 'popup'">
        <xsl:text>,title:</xsl:text><xsl:value-of select="x:js-quote(lego:title)"/>
        <xsl:apply-templates select="lego:register" mode="lego:js-params-content"/>
    </xsl:if>
</xsl:template>

<xsl:template match="lego:b-auth-domik/lego:register" mode="lego:js-params-content">
    <xsl:apply-templates select="." mode="lego:js-params-regtitle"/>
    <xsl:apply-templates select="." mode="lego:js-params-regmode"/>
</xsl:template>

<xsl:template match="lego:b-auth-domik/lego:register" mode="lego:js-params-regtitle"/>
<xsl:template match="lego:b-auth-domik/lego:register[string(.)]" mode="lego:js-params-regtitle">
    <xsl:text>,register:</xsl:text><xsl:value-of select="x:js-quote(lego:register)"/>
</xsl:template>

<xsl:template match="lego:b-auth-domik/lego:register" mode="lego:js-params-regmode"/>
<xsl:template match="lego:b-auth-domik/lego:register[@mode]" mode="lego:js-params-regmode">
    <xsl:text>,regMode:</xsl:text><xsl:value-of select="x:js-quote(@mode)"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-domik" mode="lego:content">
    <div class="b-auth-domik__form">
        <xsl:apply-templates select="lego:title"/>
        <xsl:apply-templates select="lego:username"/>
        <xsl:apply-templates select="lego:password"/>
        <xsl:apply-templates select="." mode="lego:permanent"/>
        <xsl:apply-templates select="." mode="lego:submit"/>
        <xsl:apply-templates select="lego:register"/>
        <xsl:apply-templates select="." mode="lego:remember"/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-domik" mode="lego:action-content">
    <xsl:value-of select="$lego:params/lego:passport-host"/>
    <xsl:text>/passport?mode=auth&amp;from=</xsl:text>
    <xsl:value-of select="x:urlencode('utf-8', $lego:params/lego:passport-msg)"/>
    <xsl:if test="$lego:params/lego:retpath">
        <xsl:text>&amp;retpath=</xsl:text><xsl:value-of select="x:urlencode('utf-8', $lego:params/lego:retpath)"/>
    </xsl:if>
</xsl:template>

<xsl:template match="lego:b-auth-domik" mode="lego:method-content">
    <xsl:text>post</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-domik/lego:title">
    <div class="b-auth-domik__title">
        <xsl:apply-templates/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-domik/lego:username | lego:b-auth-domik/lego:password">
    <div class="b-auth-domik__{local-name()}">
        <xsl:apply-templates select="lego:input"/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-domik//lego:input">
    <xsl:apply-templates select="lego:hint"/>
    <div class="b-input">
        <input class="b-input__text">
            <xsl:apply-templates select="." mode="lego:attributes"/>
            <xsl:apply-templates select="." mode="lego:input-attributes"/>
        </input>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-domik//lego:input[lego:hint]" mode="lego:id-content">
    <xsl:value-of select="concat('b-auth-domik-', local-name(..))"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-domik//lego:input[@name = 'login']" mode="lego:tabindex-content">
    <xsl:text>100</xsl:text>
</xsl:template>

<xsl:template match="lego:b-auth-domik//lego:input[@name = 'passwd']" mode="lego:tabindex-content">
    <xsl:text>101</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-domik" mode="lego:permanent">
    <div class="b-auth-domik__permanent">
        <input id="b-auth-domik-permanent" class="b-auth-domik__check" name="twoweeks" type="checkbox" value="yes" tabindex="102"/>
        <label for="b-auth-domik-permanent">
            <xsl:value-of select="lego:message('b-auth:permanent', 'Запомнить меня')"/>
        </label>
        <xsl:text> </xsl:text>
        <span class="b-auth-domik__help">(<a class="b-auth-domik__link" href="http://help.yandex.ru/passport/?id=922493" tabindex="106">
            <xsl:value-of select="lego:message('b-auth:help', 'что&#160;это')"/>
        </a>)</span>
    </div>
</xsl:template>

<xsl:template match="lego:b-auth-domik" mode="lego:submit">
    <div class="b-auth-domik__button">
        <input class="b-auth-domik__submit" type="submit" value="{lego:message('b-auth:logon', 'Войти')}" tabindex="103"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-auth-domik" mode="lego:remember">
    <div class="b-auth-domik__remember">
        <a class="b-auth-domik__remind" href="{$lego:params/lego:passport-host}/passport?mode=remember" tabindex="105">
            <xsl:value-of select="lego:message('b-auth:remember', 'Вспомнить пароль')"/>
        </a>
    </div>
</xsl:template>

<xsl:template match="lego:b-auth-domik/lego:register">
    <div class="b-auth-domik__register">
        <a class="b-auth-domik__link" tabindex="104">
            <xsl:apply-templates select="." mode="lego:url"/>
            <xsl:apply-templates select="." mode="lego:text"/>
        </a>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-auth-domik/lego:register" mode="lego:url-content">
    <xsl:value-of select="$lego:params/lego:passport-host"/>
    <xsl:text>/passport?mode=</xsl:text>
    <xsl:apply-templates select="." mode="lego:regmode"/>
    <xsl:if test="$lego:params/lego:yandexuid">
        <xsl:text>&amp;yu=</xsl:text><xsl:value-of select="$lego:params/lego:yandexuid"/>
    </xsl:if>
    <xsl:if test="$lego:params/lego:retpath">
        <xsl:text>&amp;retpath=</xsl:text><xsl:value-of select="x:urlencode('utf-8', $lego:params/lego:retpath)"/>
    </xsl:if>
    <xsl:if test="$lego:params/lego:passport-msg">
        <xsl:text>&amp;from=</xsl:text><xsl:value-of select="x:urlencode('utf-8', $lego:params/lego:passport-msg)"/>
    </xsl:if>
</xsl:template>

<xsl:template match="lego:b-auth-domik/lego:register" mode="lego:regmode">
    <xsl:text>register</xsl:text>
</xsl:template>

<xsl:template match="lego:b-auth-domik/lego:register[@mode]" mode="lego:regmode">
    <xsl:value-of select="@mode"/>
</xsl:template>

<xsl:template match="lego:b-auth-domik/lego:register" mode="lego:text">
    <xsl:value-of select="."/>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

