<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:date="http://exslt.org/dates-and-times"
    exclude-result-prefixes=" lego date "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-foot//lego:copyright">
    <xsl:variable name="current-year" select="date:format-date(date:date-time(), '%Y')"/>
    <xsl:variable name="start-year" select="lego:if(@start, @start, $current-year)"/>
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:text>©&#160;</xsl:text>
        <xsl:value-of select="$start-year"/>
        <xsl:if test="$current-year != $start-year">
            <xsl:value-of select="concat('—', $current-year)"/>
        </xsl:if>
        <xsl:text> </xsl:text>
        <xsl:apply-templates select="." mode="lego:text"/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-foot//lego:copyright" mode="lego:text">
    <xsl:text>&#171;</xsl:text>
    <a class="b-foot__link" href="http://www.yandex.ru">
        <xsl:apply-templates select="." mode="lego:url"/>
        <xsl:value-of select="lego:message('b-foot-copyright-yandex', 'Яндекс')"/>
    </a>
    <xsl:text>&#187;</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-foot//lego:copyright[lego:text]" mode="lego:text">
    <xsl:apply-templates select="lego:text"/>
</xsl:template>

</xsl:stylesheet>