<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-foot//lego:lang-text">
    <span>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="lego:link">
            <xsl:sort select="@lang = $lego:locale" order="descending"/>
        </xsl:apply-templates>
    </span>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-foot//lego:lang-text/lego:link">
    <xsl:choose>
        <xsl:when test="@lang = $lego:locale">
            <xsl:apply-templates select="." mode="lego:content"/>
            <xsl:text> </xsl:text>
            <span class="b-foot__lang-text__arr">&#8594;</span>
            <xsl:text> </xsl:text>
        </xsl:when>
        <xsl:otherwise>
            <a class="b-foot__link">
                <xsl:apply-templates select="." mode="lego:url"/>
                <xsl:apply-templates select="." mode="lego:content"/>
            </a>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

</xsl:stylesheet>