(function($, Lego){

Lego.block['b-head-tabs'] = function(params){

    var thisHeadTabs = $(this),
        headSearch = thisHeadTabs.next('.b-head-search'),
        textInput = headSearch.find('.b-search .b-input input:first'),
        advancedSearch = headSearch.find('.advanced'),
        advancedBaseUrl = (advancedSearch.attr('href') || '').replace(/([?&])text=[^&]*/g, ''),
        noReaskParam = $.map(document.location.search.substr(1).split('&'), function(param) {
                var splitted = param.split('=');
                return splitted[0] == 'noreask'? splitted[1] : '';
            }).join(''),
        hostToUrl = (function() {
            var result = Lego.block['b-head-tabs'].getHostToUrlMap();
            noReaskParam && $.each(result, function(name) {
                result[name] = result[name] + getDelimiter(result[name]) + 'noreask=' + noReaskParam;
            });
            return result;
        })(),
        tabs = $.grep($.map(thisHeadTabs.find(':not(strong)>a.b-head-tabs__link:not([href$=yandex.ru/all])'), function(tab) {
            var service = tab.host.split('.')[0];
            return {
                node    : $(tab),
                clid    : ($(tab).attr('search').match(/[&?]clid=(\d+)/) || [])[1],
                service : service,
                url     : hostToUrl[service]
            };
        }), function(tab) {
            return typeof tab.url != 'undefined';
        }),
        marketClid = {'www' : 505, 'search' : 521, 'images' : 526}[Lego.params.id] || 527,
        lastTextValue;

    setInterval((function() {

        var textValue = encodeURIComponent($.trim(textInput.val()) || params['default']);

        if(lastTextValue === textValue) {
            return arguments.callee;
        }

        lastTextValue = textValue;

        if(!!advancedSearch.length) {
            advancedSearch.attr('href', advancedBaseUrl + (!!textValue?
               getDelimiter(advancedBaseUrl) + 'text=' + textValue : ''));
        }

        $.each(tabs, function() {
            var url = !!textValue?
                    (this.service == 'market'? this.url.replace('%clid%', marketClid) : this.url) +
                        getDelimiter(this.url) + Lego.block['b-head-tabs'].getSearchParamName(this.service) + '=' + textValue :
                    this.service == 'market'? '?clid=' + marketClid + '&cvredirect=1' : '',
                node = this.node[0];

            node.href = node.protocol + '//' + node.host + '/' + url +
                ((this.clid && this.service != 'market' && !(this.service == 'www' && !!textValue))?
                    getDelimiter(url) + 'clid=' + this.clid : '');
        });

        return arguments.callee;

    })(), 200);

    function getDelimiter(url) {
        return url.indexOf('?') != -1 ? '&' : '?';
    }

};

Lego.block['b-head-tabs'].getHostToUrlMap = function() {
    var result = {
        'www'    : 'yandsearch',
        'news'   : 'yandsearch?rpt=nnews&grhow=clutop',
        'yaca'   : 'yandsearch?rpt=rs2',
        'market' : 'search.xml?clid=%clid%&cvredirect=1',
        'blogs'  : 'search.xml?ft=blog',
        'maps'   : '',
        'auto'   : 'search.xml'
    };
    result['images'] = result['www'];
    result['adresa'] = result['video'] = result['fotki'] = result['slovari'] = result['auto'];
    return result;
}

Lego.block['b-head-tabs'].getSearchParamName = function(serviceId) {
    return 'text';
}

})(jQuery, window.Lego);